/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.bind;

import de.alpharogroup.check.Check;
import de.alpharogroup.model.api.Model;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringBindingListener
implements DocumentListener {
    private static final Logger log = LoggerFactory.getLogger(StringBindingListener.class);
    private Model<String> model;

    public StringBindingListener(Model<String> model) {
        Check.get().notNull(model, "model");
        this.model = model;
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.update(event);
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.update(event);
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.update(event);
    }

    protected void update(DocumentEvent event) {
        try {
            String text = event.getDocument().getText(event.getDocument().getStartPosition().getOffset(), event.getDocument().getEndPosition().getOffset() - 1);
            this.model.setObject((Object)text);
        }
        catch (BadLocationException e1) {
            log.error("some portion of the given range was not a valid part of the document. The location in the exception is the first bad position encountered.", (Throwable)e1);
        }
    }

    public Model<String> getModel() {
        return this.model;
    }
}

