/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.renderer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class TableCellButtonRenderer
extends JButton
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final String BUTTON_BACKGROUND_COLOR = "Button.background";
    private Color foreground;
    private Color backround;

    public TableCellButtonRenderer() {
        this((Color)null, (Color)null);
    }

    public TableCellButtonRenderer(Color foreground, Color backround) {
        this.setOpaque(true);
        this.foreground = foreground;
        this.backround = backround;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setForeground(this.newSelectionForeground(table));
            this.setBackground(this.newSelectionBackround(table));
        } else {
            this.setForeground(this.newForeground(table));
            this.setBackground(this.newBackround(table));
        }
        String text = "";
        if (value != null) {
            text = value.toString();
        }
        this.setText(text);
        return this;
    }

    protected Color newBackround(JTable table) {
        if (this.backround == null) {
            this.backround = UIManager.getColor(BUTTON_BACKGROUND_COLOR);
        }
        return this.backround;
    }

    protected Color newForeground(JTable table) {
        if (this.foreground == null) {
            this.foreground = table.getForeground();
        }
        return this.foreground;
    }

    protected Color newSelectionBackround(JTable table) {
        return table.getSelectionBackground();
    }

    protected Color newSelectionForeground(JTable table) {
        return table.getSelectionForeground();
    }
}

