/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.table.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public abstract class GenericTableModel<T>
extends AbstractTableModel {
    private static final long serialVersionUID = -2953355508541913548L;
    private List<T> data = new ArrayList<T>();

    public GenericTableModel() {
    }

    public GenericTableModel(List<T> list) {
        this.data.addAll(list);
    }

    public void add(T row) {
        this.data.add(row);
        this.fireTableDataChanged();
    }

    public void addList(List<T> list) {
        this.data.addAll(list);
        this.fireTableDataChanged();
    }

    public void clear() {
        if (null != this.data && !this.data.isEmpty()) {
            this.data.clear();
            this.fireTableDataChanged();
        }
    }

    public T get(int row) {
        return this.data.get(row);
    }

    public List<T> getData() {
        return this.data;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T remove(T row) {
        int index = this.data.indexOf(row);
        if (index != -1) {
            try {
                T t = this.data.remove(index);
                return t;
            }
            finally {
                this.fireTableDataChanged();
            }
        }
        return null;
    }

    public List<T> removeAll(int[] selectedRows) {
        int lastIndex;
        ArrayList<T> removedList = new ArrayList<T>();
        for (int i = lastIndex = selectedRows.length - 1; -1 < i; --i) {
            int selectedRow = selectedRows[i];
            T row = this.removeAt(selectedRow);
            removedList.add(row);
        }
        this.fireTableDataChanged();
        return removedList;
    }

    public List<T> removeAll(List<T> toRemove) {
        ArrayList<T> removedList = new ArrayList<T>();
        for (T t : toRemove) {
            int index = this.data.indexOf(t);
            if (index == -1) continue;
            removedList.add(this.data.remove(index));
        }
        this.fireTableDataChanged();
        return removedList;
    }

    public T removeAt(int row) {
        try {
            T t = this.data.remove(row);
            return t;
        }
        finally {
            this.fireTableDataChanged();
        }
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public void update(T row) {
        int index = this.data.indexOf(row);
        if (index != -1) {
            this.data.set(index, row);
            this.fireTableDataChanged();
        }
    }
}

