/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.table.model.thread;

import de.alpharogroup.lang.thread.ThreadDataBean;
import de.alpharogroup.lang.thread.ThreadExtensions;
import de.alpharogroup.swing.table.model.BaseTableModel;
import de.alpharogroup.swing.table.model.TableColumnsModel;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.SwingUtilities;

public class ThreadsTableModel
extends BaseTableModel<ThreadDataBean> {
    private static final long serialVersionUID = 1L;
    private List<ThreadDataBean> currentThreadData;
    private Object lock;
    private Thread updateRunningThreads;
    private volatile boolean running;

    public ThreadsTableModel() {
        this(TableColumnsModel.builder().columnNames(new String[]{"Priority", "Alive", "Daemon", "Interrupted", "Thread group", "Name"}).canEdit(new boolean[]{false, false, false, false, false, false}).columnClasses(new Class[]{Integer.class, Boolean.class, Boolean.class, Boolean.class, String.class, String.class}).build());
    }

    public ThreadsTableModel(TableColumnsModel columnsModel) {
        super(columnsModel);
        this.onInitialize();
    }

    @Override
    public Object getValueAt(int row, int col) {
        ThreadDataBean threadData = (ThreadDataBean)this.getData().get(row);
        switch (col) {
            case 0: {
                return threadData.getPriority();
            }
            case 1: {
                return threadData.isAlive();
            }
            case 2: {
                return threadData.isDaemon();
            }
            case 3: {
                return threadData.isInterrupted();
            }
            case 4: {
                return threadData.getThreadGroup();
            }
            case 5: {
                return threadData.getName();
            }
        }
        return null;
    }

    public void interrupt() {
        this.running = false;
        this.updateRunningThreads.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newThreadData() {
        Object object = this.lock;
        synchronized (object) {
            this.currentThreadData = ThreadExtensions.newThreadData();
        }
    }

    protected void onInitialize() {
        this.lock = new Object();
        this.running = true;
        Runnable updater = new Runnable(){

            @Override
            public void run() {
                try {
                    ThreadsTableModel.this.update();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        this.updateRunningThreads = new Thread(updater, "RunningThreadUpdater");
        this.updateRunningThreads.setPriority(10);
        this.updateRunningThreads.setDaemon(true);
        this.updateRunningThreads.start();
    }

    private void update() {
        Runnable updateCurrentRunningThreads = new Runnable(){

            @Override
            public void run() {
                ThreadsTableModel.this.updateCurrentThreadData();
                ThreadsTableModel.this.fireTableDataChanged();
            }
        };
        while (this.running) {
            try {
                this.newThreadData();
                SwingUtilities.invokeAndWait(updateCurrentRunningThreads);
                Thread.sleep(1000L);
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException exception) {
                exception.printStackTrace();
                this.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCurrentThreadData() {
        Object object = this.lock;
        synchronized (object) {
            this.setData(this.currentThreadData);
        }
    }
}

