/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing;

import de.alpharogroup.check.Check;
import de.alpharogroup.swing.GenericJTable;
import de.alpharogroup.swing.table.model.suffle.GenericShuffleTableModel;
import java.io.Serializable;

public class GenericShuffleJTable<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final GenericJTable<T> leftTable;
    private final GenericShuffleTableModel<T> model;
    private final GenericJTable<T> rightTable;

    public GenericShuffleJTable(GenericJTable<T> leftTable, GenericJTable<T> rightTable) {
        Check.get().notNull(leftTable, "leftTable").notNull(rightTable, "rightTable");
        this.leftTable = leftTable;
        this.rightTable = rightTable;
        this.model = new GenericShuffleTableModel<T>(leftTable.getGenericTableModel(), rightTable.getGenericTableModel());
    }

    public void addAllLeftRowsToRightTable() {
        this.model.addAllLeftRowsToRightTableModel();
    }

    public void addAllRightRowsToLeftTable() {
        this.model.addAllRightRowsToLeftTableModel();
    }

    public void shuffleSelectedLeftRowsToRightTable() {
        this.model.shuffleSelectedLeftRowsToRightTableModel(this.leftTable.getSelectedRows());
    }

    public void shuffleSelectedLeftRowToRightTable() {
        this.model.shuffleSelectedLeftRowToRightTableModel(this.leftTable.getSelectedRow());
    }

    public void shuffleSelectedRightRowsToLeftTable() {
        this.model.shuffleSelectedRightRowsToLeftTableModel(this.rightTable.getSelectedRows());
    }

    public void shuffleSelectedRightRowToLeftTable() {
        this.model.shuffleSelectedRightRowToLeftTableModel(this.rightTable.getSelectedRow());
    }

    public GenericJTable<T> getLeftTable() {
        return this.leftTable;
    }

    public GenericShuffleTableModel<T> getModel() {
        return this.model;
    }

    public GenericJTable<T> getRightTable() {
        return this.rightTable;
    }
}

