/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.actions;

import de.alpharogroup.check.Check;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

public abstract class OpenFileAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private JFileChooser fileChooser;
    private final Component parent;

    public OpenFileAction(String name, Component parent) {
        super(name);
        Check.get().notNull((Object)parent, "parent");
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.fileChooser = new JFileChooser();
        this.onFileChoose(this.fileChooser, actionEvent);
    }

    protected abstract void onApproveOption(File var1, ActionEvent var2);

    protected abstract void onCancel(ActionEvent var1);

    protected void onFileChoose(JFileChooser fileChooser, ActionEvent actionEvent) {
        int returnVal = fileChooser.showOpenDialog(this.parent);
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            this.onApproveOption(file, actionEvent);
        } else {
            this.onCancel(actionEvent);
        }
    }

    public JFileChooser getFileChooser() {
        return this.fileChooser;
    }

    public Component getParent() {
        return this.parent;
    }
}

