/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.components.factories;

import de.alpharogroup.lang.ClassExtensions;
import de.alpharogroup.swing.menu.MenuItemBean;
import de.alpharogroup.swing.menu.popup.listeners.PopupListener;
import de.alpharogroup.swing.splashscreen.SplashScreen;
import java.awt.Component;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public final class JComponentFactory {
    public static HelpSet newHelpSet(String directoryPath, String filename) throws HelpSetException {
        String absolutePath = directoryPath + filename;
        URL hsURL = ClassExtensions.getResource((String)absolutePath);
        HelpSet hs = new HelpSet(ClassExtensions.getClassLoader(), hsURL);
        return hs;
    }

    public static JInternalFrame newInternalFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        JInternalFrame internalFrame = new JInternalFrame(title, resizable, closable, maximizable, iconifiable);
        return internalFrame;
    }

    public static JPopupMenu newJPopupMenu() {
        return JComponentFactory.newJPopupMenu("");
    }

    public static JPopupMenu newJPopupMenu(Component component, JMenuItem ... items) {
        return JComponentFactory.newJPopupMenu("", component, items);
    }

    public static JPopupMenu newJPopupMenu(String label) {
        JPopupMenu popup = new JPopupMenu(label);
        return popup;
    }

    public static JPopupMenu newJPopupMenu(String label, Component component, JMenuItem ... items) {
        JPopupMenu popup = JComponentFactory.newJPopupMenu(label);
        for (JMenuItem jMenuItem : items) {
            popup.add(jMenuItem);
        }
        PopupListener popupListener = new PopupListener(popup);
        component.addMouseListener(popupListener);
        return popup;
    }

    public static JToolBar newJToolBar() {
        return new JToolBar();
    }

    public static PopupMenu newPopupMenu(List<MenuItemBean> menuItemBeans) {
        PopupMenu popupMenu = new PopupMenu();
        for (MenuItemBean menuItemBean : menuItemBeans) {
            MenuItem miBringToFront = new MenuItem(menuItemBean.getLabel());
            miBringToFront.setActionCommand(menuItemBean.getCommand());
            miBringToFront.addActionListener(menuItemBean.getActionListener());
            popupMenu.add(miBringToFront);
        }
        return popupMenu;
    }

    public static SplashScreen newSplashScreen(String image, String text) {
        SplashScreen splashscreen = new SplashScreen(image, text);
        return splashscreen;
    }

    public static TrayIcon newTrayIcon(String imgFilename, String appName, PopupMenu systemTrayPopupMenu, Map<String, ActionListener> actionListeners) {
        Image image = Toolkit.getDefaultToolkit().getImage(imgFilename);
        TrayIcon trayIcon = new TrayIcon(image, appName, systemTrayPopupMenu);
        for (Map.Entry<String, ActionListener> actionListener : actionListeners.entrySet()) {
            trayIcon.setActionCommand(actionListener.getKey());
            trayIcon.addActionListener(actionListener.getValue());
        }
        return trayIcon;
    }
}

