/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.document;

import de.alpharogroup.math.MathExtensions;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class RangeDocument
extends PlainDocument {
    private static final long serialVersionUID = 1L;
    private final int maximum;
    private final int minimum;

    public RangeDocument(int minimum, int maximum) {
        this.minimum = minimum;
        this.maximum = maximum;
    }

    @Override
    public void insertString(int offset, String string, AttributeSet attributes) throws BadLocationException {
        String newValue;
        if (string == null) {
            return;
        }
        int length = this.getLength();
        if (length == 0) {
            newValue = string;
        } else {
            String currentContent = this.getText(0, length);
            StringBuffer currentBuffer = new StringBuffer(currentContent);
            currentBuffer.insert(offset, string);
            newValue = currentBuffer.toString();
        }
        try {
            this.validate(newValue);
            super.insertString(offset, string, attributes);
        }
        catch (Exception exception) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        int currentLength = this.getLength();
        String currentContent = this.getText(0, currentLength);
        String before = currentContent.substring(0, offset);
        String after = currentContent.substring(length + offset, currentLength);
        String newValue = before + after;
        try {
            this.validate(newValue);
            super.remove(offset, length);
        }
        catch (Exception exception) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public String validate(String proposedValue) throws IllegalArgumentException {
        if (MathExtensions.isBetween((int)this.minimum, (int)this.maximum, (int)proposedValue.length(), (boolean)true, (boolean)true)) {
            return proposedValue;
        }
        throw new IllegalArgumentException();
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }
}

