/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.panels.shuffletables;

import de.alpharogroup.model.BaseModel;
import de.alpharogroup.model.api.Model;
import de.alpharogroup.swing.GenericJTable;
import de.alpharogroup.swing.GenericShuffleJTable;
import de.alpharogroup.swing.base.BasePanel;
import de.alpharogroup.swing.components.factories.JComponentFactory;
import de.alpharogroup.swing.table.model.GenericTableModel;
import de.alpharogroup.swing.table.model.suffle.actions.AddAction;
import de.alpharogroup.swing.table.model.suffle.actions.AddAllAction;
import de.alpharogroup.swing.table.model.suffle.actions.RemoveAction;
import de.alpharogroup.swing.table.model.suffle.actions.RemoveAllAction;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public abstract class AbstractShuffleTablePanel<T>
extends BasePanel<List<T>> {
    private static final long serialVersionUID = 1L;
    private AddAction<T> addAction;
    private AddAllAction<T> addAllAction;
    private JButton btnAdd;
    private JButton btnAddAll;
    private JButton btnRemove;
    private JButton btnRemoveAll;
    private RemoveAction<T> removeAction;
    private RemoveAllAction<T> removeAllAction;
    private JScrollPane scrPnTblLeft;
    private JScrollPane scrPnTblRight;
    private GenericShuffleJTable<T> shuffleTable;
    private GenericJTable<T> tblLeft;
    private GenericJTable<T> tblRight;

    public AbstractShuffleTablePanel() {
        this((Model<List<T>>)BaseModel.ofList(new ArrayList()));
    }

    public AbstractShuffleTablePanel(Model<List<T>> model) {
        super(model);
    }

    protected abstract GenericTableModel<T> newLeftTableModel();

    protected abstract GenericTableModel<T> newRightTableModel();

    @Override
    protected void onInitializeComponents() {
        super.onInitializeComponents();
        this.tblRight = new GenericJTable<T>(this.newRightTableModel());
        this.tblLeft = new GenericJTable<T>(this.newLeftTableModel());
        GenericTableModel tableModel = (GenericTableModel)this.tblLeft.getModel();
        tableModel.addList((List)this.getModelObject());
        this.shuffleTable = new GenericShuffleJTable<T>(this.tblLeft, this.tblRight);
        this.addAction = new AddAction<T>(this.shuffleTable);
        this.removeAction = new RemoveAction<T>(this.shuffleTable);
        this.addAllAction = new AddAllAction<T>(this.shuffleTable);
        this.removeAllAction = new RemoveAllAction<T>(this.shuffleTable);
        JMenuItem addMenuItem = new JMenuItem("Selected row to right >");
        addMenuItem.addActionListener(this.addAction);
        JMenuItem addAllMenuItem = new JMenuItem("All selected rows to right >>");
        addAllMenuItem.addActionListener(this.addAllAction);
        JPopupMenu leftTablePopupMenu = JComponentFactory.newJPopupMenu(this.shuffleTable.getLeftTable(), addMenuItem, addAllMenuItem);
        this.shuffleTable.getLeftTable().add(leftTablePopupMenu);
        JMenuItem removeMenuItem = new JMenuItem("< Selected row to left");
        removeMenuItem.addActionListener(this.removeAction);
        JMenuItem removeAllMenuItem = new JMenuItem("<< All selected rows to left");
        removeAllMenuItem.addActionListener(this.removeAllAction);
        JPopupMenu rightTablePopupMenu = JComponentFactory.newJPopupMenu(this.shuffleTable.getRightTable(), removeMenuItem, removeAllMenuItem);
        this.shuffleTable.getRightTable().add(rightTablePopupMenu);
        this.shuffleTable.getLeftTable().add(leftTablePopupMenu);
        this.btnAdd = new JButton(this.addAction);
        this.btnAddAll = new JButton(this.addAllAction);
        this.btnRemove = new JButton(this.removeAction);
        this.btnRemoveAll = new JButton(this.removeAllAction);
        this.btnAdd.setText("Add>");
        this.btnAddAll.setText("Add all>>");
        this.btnRemove.setText("<Remove");
        this.btnRemoveAll.setText("<<Remove all");
        this.scrPnTblRight = new JScrollPane();
        this.scrPnTblLeft = new JScrollPane();
        this.scrPnTblLeft.setViewportView(this.tblLeft);
        this.scrPnTblRight.setViewportView(this.tblRight);
    }

    @Override
    protected void onInitializeLayout() {
        super.onInitializeLayout();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 6;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.add(this.scrPnTblLeft, gbc);
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.add(this.btnAdd, gbc);
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.add(this.btnAddAll, gbc);
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.add(this.btnRemoveAll, gbc);
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.add(this.btnRemove, gbc);
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 6;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.add(this.scrPnTblRight, gbc);
    }

    public AddAction<T> getAddAction() {
        return this.addAction;
    }

    public AddAllAction<T> getAddAllAction() {
        return this.addAllAction;
    }

    public JButton getBtnAdd() {
        return this.btnAdd;
    }

    public JButton getBtnAddAll() {
        return this.btnAddAll;
    }

    public JButton getBtnRemove() {
        return this.btnRemove;
    }

    public JButton getBtnRemoveAll() {
        return this.btnRemoveAll;
    }

    public RemoveAction<T> getRemoveAction() {
        return this.removeAction;
    }

    public RemoveAllAction<T> getRemoveAllAction() {
        return this.removeAllAction;
    }

    public JScrollPane getScrPnTblLeft() {
        return this.scrPnTblLeft;
    }

    public JScrollPane getScrPnTblRight() {
        return this.scrPnTblRight;
    }

    public GenericShuffleJTable<T> getShuffleTable() {
        return this.shuffleTable;
    }

    public GenericJTable<T> getTblLeft() {
        return this.tblLeft;
    }

    public GenericJTable<T> getTblRight() {
        return this.tblRight;
    }
}

