/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.panels.tree;

import de.alpharogroup.model.api.Model;
import de.alpharogroup.swing.base.BasePanel;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;

public abstract class JTreePanel<T>
extends BasePanel<T> {
    private static final long serialVersionUID = 1L;
    protected JScrollPane scrTree;
    protected JTree tree;

    public JTreePanel() {
    }

    public JTreePanel(Model<T> model) {
        super(model);
    }

    protected Dimension newPreferredSize(int width, int height) {
        return new Dimension(width, height);
    }

    protected JTree newTree() {
        final JTree tree = new JTree();
        tree.setModel(this.newTreeModel(this.getModel()));
        tree.setEditable(true);
        tree.getSelectionModel().setSelectionMode(1);
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = tree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    if (e.getClickCount() == 1) {
                        JTreePanel.this.onSingleClick(e);
                    } else if (e.getClickCount() == 2) {
                        JTreePanel.this.onDoubleClick(e);
                    }
                }
            }
        });
        return tree;
    }

    protected abstract TreeModel newTreeModel(Model<T> var1);

    protected JScrollPane newTreeScrollPane() {
        JScrollPane scrDbTree = new JScrollPane();
        return scrDbTree;
    }

    protected void onDoubleClick(MouseEvent event) {
    }

    @Override
    protected void onInitializeComponents() {
        super.onInitializeComponents();
        this.scrTree = this.newTreeScrollPane();
        this.tree = this.newTree();
        this.setPreferredSize(this.newPreferredSize(420, 560));
        this.scrTree.setViewportView(this.tree);
    }

    @Override
    protected void onInitializeLayout() {
        super.onInitializeLayout();
    }

    protected void onSingleClick(MouseEvent event) {
    }

    public JScrollPane getScrTree() {
        return this.scrTree;
    }

    public JTree getTree() {
        return this.tree;
    }
}

