/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.renderer;

import java.text.SimpleDateFormat;
import java.util.Objects;
import javax.swing.table.DefaultTableCellRenderer;

public class DateRenderer
extends DefaultTableCellRenderer {
    public static final String DEFAULT_PATTERN = "dd.MM.yyyy";
    private static final long serialVersionUID = 1L;
    private final SimpleDateFormat dateFormatter;
    private String datePattern;

    public DateRenderer() {
        this(DEFAULT_PATTERN);
    }

    public DateRenderer(String pattern) {
        this.datePattern = pattern;
        this.dateFormatter = new SimpleDateFormat(this.datePattern);
    }

    @Override
    protected void setValue(Object value) {
        this.setText(Objects.isNull(value) ? "" : this.dateFormatter.format(value));
    }

    public String getDatePattern() {
        return this.datePattern;
    }
}

