/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.table.model.properties;

import de.alpharogroup.collections.properties.IndexSortedProperties;
import de.alpharogroup.swing.table.model.properties.PropertiesColumns;
import java.util.Map;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;

public class PropertiesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private IndexSortedProperties data;

    public PropertiesTableModel() {
        this((Properties)new IndexSortedProperties());
    }

    public PropertiesTableModel(Properties properties) {
        this.setProperties(properties);
    }

    public void add(Properties properties) {
        this.data.putAll((Map)properties);
        this.fireTableDataChanged();
    }

    public void add(String key, String value) {
        this.data.setProperty(key, value);
        this.fireTableDataChanged();
    }

    public void clear() {
        if (null != this.data && !this.data.isEmpty()) {
            this.data.clear();
            this.fireTableDataChanged();
        }
    }

    public String get(int row) {
        return this.data.getProperty(row);
    }

    public String get(String key) {
        return this.data.getProperty(key);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return PropertiesColumns.values().length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        PropertiesColumns column = PropertiesColumns.values()[columnIndex];
        switch (column) {
            case KEY: {
                return "Key";
            }
            case VALUE: {
                return "Value";
            }
        }
        return "";
    }

    public Properties getData() {
        return this.data;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String key = (String)this.data.get(rowIndex);
        PropertiesColumns column = PropertiesColumns.values()[columnIndex];
        switch (column) {
            case KEY: {
                return key;
            }
            case VALUE: {
                return this.data.get((Object)key);
            }
        }
        return null;
    }

    public String remove(String key) {
        return (String)this.data.remove((Object)key);
    }

    public void setData(Properties properties) {
        this.setProperties(properties);
    }

    protected void setProperties(Properties properties) {
        this.data = new IndexSortedProperties(properties);
    }
}

