/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.throwable;

import de.alpharogroup.throwable.api.ThrowableConsumer;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public final class ThrowableExtensions {
    private ThrowableExtensions() {
    }

    public static <T> Consumer<T> toRuntimeExceptionIfNeeded(ThrowableConsumer<T, Throwable> throwableConsumer) {
        return object -> {
            try {
                throwableConsumer.accept(object);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        };
    }

    public static String getStackTrace(Throwable throwable, String ... additionalInfos) throws IOException {
        Objects.requireNonNull(throwable);
        StringBuilder stacktrace = ThrowableExtensions.getAdditionalInfos(additionalInfos);
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            throwable.printStackTrace(pw);
            stacktrace.append(sw.toString());
        }
        return stacktrace.toString();
    }

    public static String getStackTraceElements(Throwable throwable, String ... additionalInfos) throws IOException {
        Objects.requireNonNull(throwable);
        StringBuilder stacktrace = ThrowableExtensions.getAdditionalInfos(additionalInfos);
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            pw.println(throwable.getClass().toString());
            while (throwable != null) {
                StackTraceElement[] stackTraceElements;
                pw.println(throwable);
                for (StackTraceElement stackTraceElement : stackTraceElements = throwable.getStackTrace()) {
                    pw.println("\tat " + stackTraceElement);
                }
                if ((throwable = throwable.getCause()) == null) continue;
                pw.println("Caused by:\r\n");
            }
            stacktrace.append(sw.toString());
        }
        return stacktrace.toString();
    }

    private static StringBuilder getAdditionalInfos(String ... additionalInfos) {
        return ThrowableExtensions.getAdditionalInfos(", ", additionalInfos);
    }

    private static StringBuilder getAdditionalInfos(String delimiter, String ... additionalInfos) {
        StringBuilder stacktrace = new StringBuilder();
        if (additionalInfos != null && 0 < additionalInfos.length) {
            stacktrace.append(Arrays.stream(additionalInfos).map(Object::toString).collect(Collectors.joining(delimiter)));
            stacktrace.append(" ");
        }
        return stacktrace;
    }

    public static String newThrowableMessage(Throwable throwable, String additionalInfo) {
        Objects.requireNonNull(throwable);
        return additionalInfo + " [" + throwable.getClass().getSimpleName() + "]: " + Objects.toString(throwable.getMessage(), "empty message");
    }
}

