/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.service.util;

import de.alpharogroup.user.entities.Permissions;
import de.alpharogroup.user.entities.RelationPermissions;
import de.alpharogroup.user.entities.ResetPasswords;
import de.alpharogroup.user.entities.Users;
import java.util.Date;

public class HqlStringCreator {
    public static String forPermissions(String description, String permissionName, String shortcut) {
        boolean shortcutIsNotNull;
        boolean permissionNameIsNotNull;
        boolean descriptionIsNotNull;
        StringBuilder sb = new StringBuilder();
        sb.append("select p from " + Permissions.class.getSimpleName() + " p");
        boolean bl = descriptionIsNotNull = description != null && !description.isEmpty();
        if (descriptionIsNotNull) {
            sb.append(" ");
            sb.append("where p.description=:description");
        }
        boolean bl2 = permissionNameIsNotNull = permissionName != null && !permissionName.isEmpty();
        if (permissionNameIsNotNull) {
            sb.append(" ");
            if (descriptionIsNotNull) {
                sb.append("and p.permissionName=:permissionName");
            } else {
                sb.append("where p.permissionName=:permissionName");
            }
        }
        boolean bl3 = shortcutIsNotNull = shortcut != null && !shortcut.isEmpty();
        if (shortcutIsNotNull) {
            sb.append(" ");
            if (!descriptionIsNotNull && !permissionNameIsNotNull) {
                sb.append("where p.shortcut=:shortcut");
            } else {
                sb.append("and p.shortcut=:shortcut");
            }
        }
        return sb.toString();
    }

    public static String forRelationPermissions(Users provider, Users subscriber, Permissions permission) {
        boolean permissionIsNotNull;
        boolean subscriberIsNotNull;
        boolean providerIsNotNull;
        StringBuilder sb = new StringBuilder();
        sb.append("select rp from " + RelationPermissions.class.getSimpleName() + " rp");
        boolean bl = providerIsNotNull = provider != null;
        if (providerIsNotNull) {
            sb.append(" ");
            sb.append("where rp.provider=:provider");
        }
        boolean bl2 = subscriberIsNotNull = subscriber != null;
        if (subscriberIsNotNull) {
            sb.append(" ");
            if (providerIsNotNull) {
                sb.append("and rp.subscriber=:subscriber");
            } else {
                sb.append("where rp.subscriber=:subscriber");
            }
        }
        boolean bl3 = permissionIsNotNull = permission != null;
        if (permissionIsNotNull) {
            sb.append(" ");
            if (!providerIsNotNull && !subscriberIsNotNull) {
                sb.append("where :permission in elements(rp.permissions)");
            } else {
                sb.append("and :permission in elements(rp.permissions)");
            }
        }
        return sb.toString();
    }

    public static String forResetPasswords(Users user, String generatedPassword, Date expiryDate, Date starttime) {
        boolean starttimeIsNotNull;
        boolean expiryDateIsNotNull;
        boolean generatedPasswordIsNotNull;
        boolean userIsNotNull;
        StringBuilder sb = new StringBuilder();
        sb.append("select r from " + ResetPasswords.class.getSimpleName() + " r");
        boolean bl = userIsNotNull = user != null;
        if (userIsNotNull) {
            sb.append(" ");
            sb.append("where r.user=:user");
        }
        boolean bl2 = generatedPasswordIsNotNull = generatedPassword != null && !generatedPassword.isEmpty();
        if (generatedPasswordIsNotNull) {
            sb.append(" ");
            if (userIsNotNull) {
                sb.append("and r.generatedPassword=:generatedPassword");
            } else {
                sb.append("where r.generatedPassword=:generatedPassword");
            }
        }
        boolean bl3 = expiryDateIsNotNull = expiryDate != null;
        if (expiryDateIsNotNull) {
            sb.append(" ");
            if (!userIsNotNull && !generatedPasswordIsNotNull) {
                sb.append("where r.expiryDate=:expiryDate");
            } else {
                sb.append("and r.expiryDate=:expiryDate");
            }
        }
        boolean bl4 = starttimeIsNotNull = starttime != null;
        if (starttimeIsNotNull) {
            sb.append(" ");
            if (!(userIsNotNull || generatedPasswordIsNotNull || expiryDateIsNotNull)) {
                sb.append("where rv.starttime=:starttime");
            } else {
                sb.append("and rv.starttime=:starttime");
            }
        }
        return sb.toString();
    }
}

