/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.date;

import de.alpharogroup.date.CalculateDateExtensions;
import de.alpharogroup.date.CreateDateExtensions;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class Age
implements Serializable {
    private static final long serialVersionUID = -1110889254918807595L;
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_DEFAULT_MONTH = 2592000000L;
    public static final long ONE_YEAR = 31557600000L;
    private final long elapsed;
    private final Calendar birthday;
    private final Calendar till;

    public static Age of(long startFrom) {
        return new Age(startFrom);
    }

    public static Age of(Date birthday) {
        return new Age(birthday);
    }

    public static Age of(Date birthday, Date till) {
        return new Age(birthday);
    }

    public Age(long elapsed) {
        this(new Date(CreateDateExtensions.now().getTime() - elapsed));
    }

    public Age(Date birthday) {
        this(birthday, new Date(System.currentTimeMillis()));
    }

    public Age(Date birthday, Date till) {
        this.elapsed = CalculateDateExtensions.calculateElapsedTime(birthday, till);
        this.birthday = Calendar.getInstance();
        this.birthday.setTime(birthday);
        this.till = Calendar.getInstance();
        this.till.setTime(till);
    }

    public double calculateInDays() {
        return this.calculateInDays(this.elapsed);
    }

    public double calculateInDays(long time) {
        return (double)time / 8.64E7;
    }

    public double calculateInDefaultMonth() {
        return this.calculateInDefaultMonth(this.elapsed);
    }

    public double calculateInDefaultMonth(long time) {
        return (double)time / 2.592E9;
    }

    public double calculateInHours() {
        return this.calculateInHours(this.elapsed);
    }

    public double calculateInHours(long time) {
        return (double)time / 3600000.0;
    }

    public double calculateInMinutes() {
        return this.calculateInMinutes(this.elapsed);
    }

    public double calculateInMinutes(long time) {
        return (double)time / 60000.0;
    }

    public double calculateInSeconds() {
        return this.calculateInSeconds(this.elapsed);
    }

    public double calculateInSeconds(long time) {
        return (double)time / 1000.0;
    }

    public double calculateInYears() {
        return this.calculateInYears(this.elapsed);
    }

    public double calculateInYears(long el) {
        return (double)el / 3.15576E10;
    }

    public int[] calculateInYearsMonthsDaysHoursMinutesAndSeconds() {
        return this.calculateInYearsMonthsDaysHoursMinutesAndSeconds(this.elapsed);
    }

    public int[] calculateInYearsMonthsDaysHoursMinutesAndSeconds(long compute) {
        long uebrig = -1L;
        int[] result = new int[6];
        int years = (int)this.calculateInYears(compute);
        if (0 < years) {
            result[0] = years;
            uebrig = compute - (long)years * 31557600000L;
        } else {
            result[0] = 0;
        }
        int months = (int)this.calculateInDefaultMonth(uebrig);
        if (0 < months) {
            result[1] = months;
            uebrig -= (long)months * 2592000000L;
        } else {
            result[1] = 0;
        }
        int days = (int)this.calculateInDays(uebrig);
        if (0 < days) {
            result[2] = days;
            uebrig -= (long)days * 86400000L;
        } else {
            result[2] = 0;
        }
        int hours = (int)this.calculateInHours(uebrig);
        if (0 < hours) {
            result[3] = hours;
            uebrig -= (long)hours * 3600000L;
        } else {
            result[3] = 0;
        }
        int minutes = (int)this.calculateInMinutes(uebrig);
        if (0 < minutes) {
            result[4] = minutes;
            uebrig -= (long)minutes * 60000L;
        } else {
            result[4] = 0;
        }
        int seconds = (int)this.calculateInSeconds(uebrig);
        if (0 < seconds) {
            result[5] = seconds;
            uebrig -= (long)seconds * 1000L;
        } else {
            result[5] = 0;
        }
        return result;
    }

    public String getHumanReadableAge() {
        return this.getHumanReadableAge(this.calculateInYearsMonthsDaysHoursMinutesAndSeconds());
    }

    public String getHumanReadableAge(int[] readableAge) {
        if (null == readableAge || readableAge.length != 6) {
            throw new IllegalArgumentException("Int array should not be null and the length should be equal 6.");
        }
        StringBuffer result = new StringBuffer();
        result.append("Your are ");
        result.append(readableAge[0]).append(" years");
        result.append(" ");
        result.append(readableAge[1]).append(" months");
        result.append(" ");
        result.append(readableAge[2]).append(" days");
        result.append(" ");
        result.append(readableAge[3]).append(" hours");
        result.append(" ");
        result.append(readableAge[4]).append(" minutes");
        result.append(" ");
        result.append(readableAge[5]).append(" seconds");
        result.append(" young!");
        return result.toString();
    }
}

