/*
 * Decompiled with CFR 0.152.
 */
package raml.tools.html;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.io.StringTemplateSource;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import java.util.Map;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.MimeType;
import org.raml.model.Response;
import raml.tools.model.RamlContext;
import raml.tools.model.ResourceContext;
import raml.tools.util.IoUtil;

public class Raml2HtmlRenderer {
    private final Handlebars handlebars;
    private final RamlContext raml;

    public Raml2HtmlRenderer(RamlContext raml, Handlebars handlebars) {
        this.handlebars = handlebars;
        this.raml = raml;
    }

    public String renderFull() {
        return this.renderFull(null);
    }

    public String renderFull(String mainTemplateFile) {
        return this.renderClassPathTemplate(this.orDefault(mainTemplateFile, "template.hbs"), this.raml);
    }

    public String renderResource(String uri) {
        return this.renderResource(uri, null);
    }

    public String renderResource(String uri, String resourceTemplateFile) {
        return this.renderClassPathTemplate(this.orDefault(resourceTemplateFile, "resource.hbs"), this.getResourceContext(uri));
    }

    public String renderExample(String uri, String method, String status, String mimeType) {
        Action action = this.getResourceContext(uri).getAction(ActionType.valueOf((String)method.toUpperCase()));
        String exampleFormat = "<div class=\"listingblock\"><div class=\"content\"><pre class=\"CodeRay highlight raml_example\">%s</pre></div></div>";
        if (status != null) {
            String exampleForResponse = ((MimeType)this.getResponseForAction(action, status).getBody().get(mimeType)).getExample();
            return String.format(exampleFormat, exampleForResponse);
        }
        return String.format(exampleFormat, ((MimeType)action.getBody().get(mimeType)).getExample());
    }

    public String renderHeaderList(String uri, String method, String status) {
        Action action = this.getResourceContext(uri).getAction(ActionType.valueOf((String)method.toUpperCase()));
        if (status != null) {
            return this.renderClassPathTemplate("header_list.hbs", this.getResponseForAction(action, status).getHeaders());
        }
        return this.renderClassPathTemplate("header_list.hbs", action.getHeaders());
    }

    public String renderSchema(String schemaName) {
        if (this.raml.getConsolidatedSchemas().get(schemaName) == null) {
            throw new IllegalArgumentException("schema does not exist: " + schemaName);
        }
        return this.renderClassPathTemplate("schema.hbs", this.raml.getConsolidatedSchemas().get(schemaName));
    }

    public String renderStatuses(String uri, String method) {
        Action action = this.getResourceContext(uri).getAction(ActionType.valueOf((String)method.toUpperCase()));
        return this.renderClassPathTemplate("statuses.hbs", action.getResponses());
    }

    public String getBaseUri() {
        return this.raml.getBaseUri();
    }

    protected Response getResponseForAction(Action action, String status) {
        for (Map.Entry response : action.getResponses().entrySet()) {
            if (!((String)response.getKey()).equals(status)) continue;
            return (Response)response.getValue();
        }
        throw new IllegalArgumentException(String.format("no response found for status %s in action %s", status, action));
    }

    public String renderRamlContext(String templateContent) {
        return this.renderHandlebars(templateContent, this.raml);
    }

    private ResourceContext getResourceContext(String uri) {
        for (ResourceContext resourceContext : this.raml.getResources()) {
            if (resourceContext.getUri().equals(uri)) {
                return resourceContext;
            }
            for (ResourceContext subResource : resourceContext.getResources()) {
                if (!subResource.getUri().equals(uri)) continue;
                return subResource;
            }
        }
        throw new IllegalArgumentException("resource not found in RAML: " + uri);
    }

    String renderClassPathTemplate(String classPathTemplate, Object context) {
        return this.renderHandlebars(this.fileContent(classPathTemplate), context);
    }

    private String renderHandlebars(String templateContent, Object context) {
        try {
            Template template = this.handlebars.compile((TemplateSource)new StringTemplateSource("raml_template", templateContent));
            return template.apply(context);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String fileContent(String templateLocation) {
        return IoUtil.contentFromFile(templateLocation);
    }

    <T> T orDefault(T nullable, T defaultValue) {
        if (nullable == null) {
            return defaultValue;
        }
        return nullable;
    }
}

