/*
 * Decompiled with CFR 0.152.
 */
package raml.tools.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.raml.model.DocumentationItem;
import org.raml.model.Protocol;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.model.SecurityReference;
import org.raml.model.SecurityScheme;
import org.raml.model.Template;
import org.raml.model.parameter.UriParameter;
import raml.tools.model.ResourceContext;
import raml.tools.model.SchemaContext;

public class RamlContext {
    Raml raml;

    public RamlContext(Raml raml) {
        this.raml = raml;
    }

    public List<ResourceContext> getResources() {
        ArrayList<ResourceContext> arrayList = new ArrayList<ResourceContext>();
        for (Resource resource : this.raml.getResources().values()) {
            arrayList.add(new ResourceContext(resource));
        }
        return arrayList;
    }

    public List<DocumentationItem> getDocumentation() {
        return this.raml.getDocumentation();
    }

    public String getTitle() {
        return this.raml.getTitle();
    }

    public String getVersion() {
        return this.raml.getVersion();
    }

    public String getBaseUri() {
        return this.raml.getBaseUri();
    }

    public String getBasePath() {
        return this.raml.getBasePath();
    }

    public String getUri() {
        return this.raml.getUri();
    }

    public String getMediaType() {
        return this.raml.getMediaType();
    }

    public Map<String, UriParameter> getBaseUriParameters() {
        return this.raml.getBaseUriParameters();
    }

    public List<Map<String, Template>> getResourceTypes() {
        return this.raml.getResourceTypes();
    }

    public List<Map<String, Template>> getTraits() {
        return this.raml.getTraits();
    }

    public List<Map<String, String>> getSchemas() {
        return this.raml.getSchemas();
    }

    public List<Protocol> getProtocols() {
        return this.raml.getProtocols();
    }

    public List<Map<String, SecurityScheme>> getSecuritySchemes() {
        return this.raml.getSecuritySchemes();
    }

    public List<SecurityReference> getSecuredBy() {
        return this.raml.getSecuredBy();
    }

    public Map<String, SchemaContext> getConsolidatedSchemas() {
        HashMap<String, SchemaContext> hashMap = new HashMap<String, SchemaContext>();
        for (Map.Entry entry : this.raml.getConsolidatedSchemas().entrySet()) {
            hashMap.put((String)entry.getKey(), new SchemaContext((String)entry.getKey(), (String)entry.getValue()));
        }
        return hashMap;
    }
}

