/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.HandlebarsError;
import com.github.jknack.handlebars.HandlebarsException;
import com.github.jknack.handlebars.TagType;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.TypeSafeTemplate;
import com.github.jknack.handlebars.internal.FastStringWriter;
import com.github.jknack.handlebars.internal.JSEngine;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

abstract class BaseTemplate
implements Template {
    protected int line;
    protected int column;
    protected String filename;
    private final Object jsLock = new Object();
    private String javaScript;

    BaseTemplate() {
    }

    @Override
    public final String apply(Object context) throws IOException {
        return this.apply(BaseTemplate.wrap(context));
    }

    @Override
    public final void apply(Object context, Writer writer) throws IOException {
        this.apply(BaseTemplate.wrap(context), writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String apply(Context context) throws IOException {
        FastStringWriter writer = new FastStringWriter();
        try {
            this.apply(context, (Writer)writer);
            String string = writer.toString();
            return string;
        }
        finally {
            writer.close();
        }
    }

    @Override
    public void apply(Context context, Writer writer) throws IOException {
        Validate.notNull(writer, "A writer is required.", new Object[0]);
        Context wrapped = BaseTemplate.wrap(context);
        try {
            this.merge(wrapped, writer);
        }
        catch (HandlebarsException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String evidence = this.toString();
            String reason = ex.toString();
            String message = this.filename + ":" + this.line + ":" + this.column + ": " + reason + "\n";
            message = message + "    " + StringUtils.join((Object[])StringUtils.split(evidence, "\n"), "\n    ");
            HandlebarsError error = new HandlebarsError(this.filename, this.line, this.column, reason, evidence, message);
            HandlebarsException hex = new HandlebarsException(error, (Throwable)ex);
            hex.setStackTrace(ex.getStackTrace());
            throw hex;
        }
        finally {
            if (wrapped != context) {
                wrapped.destroy();
            }
        }
    }

    private static Context wrap(Object candidate) {
        if (candidate instanceof Context) {
            return (Context)candidate;
        }
        return Context.newContext(candidate);
    }

    protected abstract void merge(Context var1, Writer var2) throws IOException;

    public final String toString() {
        return this.filename + ":" + this.line + ":" + this.column;
    }

    public BaseTemplate filename(String filename) {
        this.filename = filename;
        return this;
    }

    @Override
    public String filename() {
        return this.filename;
    }

    @Override
    public int[] position() {
        return new int[]{this.line, this.column};
    }

    public BaseTemplate position(int line, int column) {
        this.line = line;
        this.column = column;
        return this;
    }

    @Override
    public <T, S extends TypeSafeTemplate<T>> S as(Class<S> rootType) {
        Validate.notNull(rootType, "The rootType can't be null.", new Object[0]);
        Validate.isTrue(rootType.isInterface(), "Not an interface: %s", rootType.getName());
        TypeSafeTemplate template = (TypeSafeTemplate)BaseTemplate.newTypeSafeTemplate(rootType, this);
        return (S)template;
    }

    @Override
    public <T> TypeSafeTemplate<T> as() {
        TypeSafeTemplate template = (TypeSafeTemplate)BaseTemplate.newTypeSafeTemplate(TypeSafeTemplate.class, this);
        return template;
    }

    private static Object newTypeSafeTemplate(Class<?> rootType, final Template template) {
        return Proxy.newProxyInstance(template.getClass().getClassLoader(), new Class[]{rootType}, new InvocationHandler(){
            private Map<String, Object> attributes = new HashMap<String, Object>();

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws IOException {
                String methodName = method.getName();
                if ("apply".equals(methodName)) {
                    Context context = Context.newBuilder(args[0]).combine(this.attributes).build();
                    this.attributes.clear();
                    if (args.length == 2) {
                        template.apply(context, (Writer)args[1]);
                        return null;
                    }
                    return template.apply(context);
                }
                if (Modifier.isPublic(method.getModifiers()) && methodName.startsWith("set")) {
                    String attrName = StringUtils.uncapitalize(methodName.substring("set".length()));
                    if (args != null && args.length == 1 && attrName.length() > 0) {
                        this.attributes.put(attrName, args[0]);
                        if (TypeSafeTemplate.class.isAssignableFrom(method.getReturnType())) {
                            return proxy;
                        }
                        return null;
                    }
                }
                String message = String.format("No handler method for: '%s(%s)', expected method signature is: 'setXxx(value)'", methodName, args == null ? "" : StringUtils.join(args, ", "));
                throw new UnsupportedOperationException(message);
            }
        });
    }

    @Override
    public List<String> collect(TagType ... tagType) {
        Validate.isTrue(tagType.length > 0, "At least one tag type is required.", new Object[0]);
        LinkedHashSet<String> tagNames = new LinkedHashSet<String>();
        for (TagType tt : tagType) {
            this.collect(tagNames, tt);
        }
        return new ArrayList<String>(tagNames);
    }

    protected void collect(Collection<String> result, TagType tagType) {
    }

    @Override
    public List<String> collectReferenceParameters() {
        LinkedHashSet<String> paramNames = new LinkedHashSet<String>();
        this.collectReferenceParameters(paramNames);
        return new ArrayList<String>(paramNames);
    }

    protected void collectReferenceParameters(Collection<String> result) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toJavaScript() {
        Object object = this.jsLock;
        synchronized (object) {
            if (this.javaScript == null) {
                this.javaScript = JSEngine.RHINO.toJavaScript(this);
            }
            return this.javaScript;
        }
    }
}

