/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.format;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.eel.kitchen.jsonschema.format.DateTimeFormatAttribute;
import org.eel.kitchen.jsonschema.format.EmailFormatAttribute;
import org.eel.kitchen.jsonschema.format.FormatAttribute;
import org.eel.kitchen.jsonschema.format.HostnameFormatAttribute;
import org.eel.kitchen.jsonschema.format.IPV4FormatAttribute;
import org.eel.kitchen.jsonschema.format.IPV6FormatAttribute;
import org.eel.kitchen.jsonschema.format.RegexFormatAttribute;
import org.eel.kitchen.jsonschema.format.URIFormatAttribute;

public final class FormatBundle {
    private static final Map<String, FormatAttribute> BUILTIN_FORMATS;
    private final Map<String, FormatAttribute> attributes;

    private FormatBundle() {
        this(Collections.emptyMap());
    }

    private FormatBundle(Map<String, FormatAttribute> attributes) {
        this.attributes = Maps.newHashMap(attributes);
    }

    public static FormatBundle newBundle() {
        return new FormatBundle();
    }

    public static FormatBundle defaultBundle() {
        return new FormatBundle(BUILTIN_FORMATS);
    }

    public void registerFormat(String fmt, FormatAttribute attribute) {
        this.attributes.put(fmt, attribute);
    }

    public void unregisterFormat(String fmt) {
        this.attributes.remove(fmt);
    }

    public void mergeWith(FormatBundle other) {
        this.attributes.putAll(other.attributes);
    }

    public Map<String, FormatAttribute> getAttributes() {
        return ImmutableMap.copyOf(this.attributes);
    }

    public String toString() {
        return "attributes: " + this.attributes.keySet();
    }

    static {
        ImmutableMap.Builder<String, FormatAttribute> builder = new ImmutableMap.Builder<String, FormatAttribute>();
        builder.put("date-time", DateTimeFormatAttribute.getInstance());
        builder.put("email", EmailFormatAttribute.getInstance());
        builder.put("host-name", HostnameFormatAttribute.getInstance());
        builder.put("ip-address", IPV4FormatAttribute.getInstance());
        builder.put("ipv6", IPV6FormatAttribute.getInstance());
        builder.put("regex", RegexFormatAttribute.getInstance());
        builder.put("uri", URIFormatAttribute.getInstance());
        BUILTIN_FORMATS = builder.build();
    }
}

