/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.util.NodeType;

public abstract class AbstractTypeKeywordValidator
extends KeywordValidator {
    private static final String ANY = "any";
    protected final EnumSet<NodeType> typeSet = EnumSet.noneOf(NodeType.class);
    protected final List<JsonNode> schemas;

    protected AbstractTypeKeywordValidator(String keyword, JsonNode schema) {
        super(keyword, NodeType.values());
        JsonNode node = schema.get(keyword);
        if (node.isTextual()) {
            this.addSimpleType(node.textValue());
            this.schemas = Collections.emptyList();
            return;
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (JsonNode element : node) {
            if (element.isTextual()) {
                this.addSimpleType(element.textValue());
                continue;
            }
            builder.add(element);
        }
        this.schemas = builder.build();
    }

    private void addSimpleType(String type) {
        if (ANY.equals(type)) {
            this.typeSet.addAll(EnumSet.allOf(NodeType.class));
            return;
        }
        NodeType tmp = NodeType.fromName(type);
        this.typeSet.add(tmp);
        if (tmp == NodeType.NUMBER) {
            this.typeSet.add(NodeType.INTEGER);
        }
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder(this.keyword).append(": primitive types ");
        sb.append(this.typeSet.isEmpty() ? "(none)" : this.typeSet);
        if (!this.schemas.isEmpty()) {
            sb.append(", schemas: ").append(this.schemas.size());
        }
        return sb.toString();
    }
}

