/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eel.kitchen.jsonschema.bundle.KeywordBundle;
import org.eel.kitchen.jsonschema.keyword.KeywordValidator;
import org.eel.kitchen.jsonschema.report.Domain;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.JacksonUtils;
import org.eel.kitchen.jsonschema.util.NodeType;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

public final class KeywordFactory {
    private final Map<String, Class<? extends KeywordValidator>> validators;

    public KeywordFactory(KeywordBundle bundle) {
        this.validators = ImmutableMap.copyOf(bundle.getValidators());
    }

    public Set<KeywordValidator> getValidators(JsonNode schema) {
        HashSet<KeywordValidator> ret = Sets.newHashSet();
        Set<String> set = JacksonUtils.fieldNames(schema);
        set.retainAll(this.validators.keySet());
        for (String keyword : set) {
            KeywordValidator validator = KeywordFactory.buildValidator(this.validators.get(keyword), schema);
            if (validator.alwaysTrue()) continue;
            ret.add(validator);
        }
        return ImmutableSet.copyOf(ret);
    }

    private static KeywordValidator buildValidator(Class<? extends KeywordValidator> c, JsonNode schema) {
        Constructor<? extends KeywordValidator> constructor;
        try {
            constructor = c.getConstructor(JsonNode.class);
        }
        catch (NoSuchMethodException e) {
            return KeywordFactory.invalidValidator(c, e);
        }
        try {
            return constructor.newInstance(schema);
        }
        catch (InstantiationException e) {
            return KeywordFactory.invalidValidator(c, e);
        }
        catch (IllegalAccessException e) {
            return KeywordFactory.invalidValidator(c, e);
        }
        catch (InvocationTargetException e) {
            return KeywordFactory.invalidValidator(c, e);
        }
    }

    private static KeywordValidator invalidValidator(Class<? extends KeywordValidator> c, final Exception e) {
        final String className = c.getName();
        return new KeywordValidator(className, NodeType.values()){

            @Override
            protected void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
                Message.Builder msg = Domain.VALIDATION.newMessage().setMessage("cannot build validator").setKeyword(className).addInfo("exception", e.getClass().getName()).addInfo("exceptionMessage", e.getMessage()).setFatal(true);
                report.addMessage(msg.build());
            }

            @Override
            public String toString() {
                return className;
            }
        };
    }
}

