/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public class TypeKeywordSyntaxChecker
extends SimpleSyntaxChecker {
    private static final String ANY = "any";
    private static final EnumSet<NodeType> VALID_TYPE_ARRAY_ELEMENTS = EnumSet.of(NodeType.OBJECT, NodeType.STRING);

    public TypeKeywordSyntaxChecker(String keyword) {
        super(keyword, NodeType.STRING, NodeType.ARRAY);
    }

    @Override
    final void checkValue(Message.Builder msg, List<Message> messages, JsonNode schema) {
        JsonNode node = schema.get(this.keyword);
        if (!node.isArray()) {
            TypeKeywordSyntaxChecker.validateOne(msg, messages, node);
            return;
        }
        HashSet<JsonNode> set = Sets.newHashSet();
        int index = 0;
        for (JsonNode value : node) {
            msg.clearInfo().addInfo("index", index);
            ++index;
            if (!set.add(value)) {
                msg.setMessage("duplicate value found in array");
                messages.add(msg.build());
                continue;
            }
            TypeKeywordSyntaxChecker.validateOne(msg, messages, value);
        }
    }

    private static void validateOne(Message.Builder msg, List<Message> messages, JsonNode value) {
        if (value.isObject()) {
            return;
        }
        if (!value.isTextual()) {
            msg.addInfo("found", NodeType.getNodeType(value)).setMessage("array element has incorrect type").addInfo("expected", VALID_TYPE_ARRAY_ELEMENTS);
            messages.add(msg.build());
            return;
        }
        String s = value.textValue();
        if (ANY.equals(s)) {
            return;
        }
        if (NodeType.fromName(s) != null) {
            return;
        }
        msg.addInfo("possible-values", EnumSet.allOf(NodeType.class)).addInfo("found", s).setMessage("unknown simple type");
        messages.add(msg.build());
    }
}

