/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.syntax;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.eel.kitchen.jsonschema.report.Message;
import org.eel.kitchen.jsonschema.syntax.SimpleSyntaxChecker;
import org.eel.kitchen.jsonschema.util.NodeType;

public final class URISyntaxChecker
extends SimpleSyntaxChecker {
    public URISyntaxChecker(String keyword) {
        super(keyword, NodeType.STRING, new NodeType[0]);
    }

    @Override
    void checkValue(Message.Builder msg, List<Message> messages, JsonNode schema) {
        String value = schema.get(this.keyword).textValue();
        try {
            new URI(value);
        }
        catch (URISyntaxException ignored) {
            msg.setMessage("not a valid URI").addInfo("found", value);
            messages.add(msg.build());
        }
    }
}

