/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public final class JacksonUtils {
    private static final JsonNode EMPTY_SCHEMA = EmptySchema.access$000();

    private JacksonUtils() {
    }

    public static Map<String, JsonNode> nodeToMap(JsonNode node) {
        HashMap<String, JsonNode> ret = Maps.newHashMap();
        Iterator<Map.Entry<String, JsonNode>> iterator = node.fields();
        while (iterator.hasNext()) {
            Map.Entry<String, JsonNode> entry = iterator.next();
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    public static SortedMap<String, JsonNode> nodeToTreeMap(JsonNode node) {
        TreeMap<String, JsonNode> ret = Maps.newTreeMap();
        Iterator<Map.Entry<String, JsonNode>> iterator = node.fields();
        while (iterator.hasNext()) {
            Map.Entry<String, JsonNode> entry = iterator.next();
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    public static Set<String> fieldNames(JsonNode node) {
        HashSet<String> ret = Sets.newHashSet();
        Iterator<String> iterator = node.fieldNames();
        while (iterator.hasNext()) {
            ret.add(iterator.next());
        }
        return ret;
    }

    public static JsonNode emptySchema() {
        return EMPTY_SCHEMA;
    }

    private static final class EmptySchema
    extends ObjectNode {
        private static final JsonNode instance = new EmptySchema();

        private static JsonNode getInstance() {
            return instance;
        }

        private EmptySchema() {
            super(JsonNodeFactory.instance);
        }

        @Override
        public ObjectNode with(String propertyName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ArrayNode withArray(String propertyName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public JsonNode put(String fieldName, JsonNode value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public JsonNode putAll(Map<String, JsonNode> properties) {
            throw new UnsupportedOperationException();
        }

        @Override
        public JsonNode putAll(ObjectNode other) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ArrayNode putArray(String fieldName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectNode putObject(String fieldName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectNode putPOJO(String fieldName, Object pojo) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectNode putNull(String fieldName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectNode put(String fieldName, int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectNode put(String fieldName, Integer value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectNode put(String fieldName, long v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectNode put(String fieldName, Long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectNode put(String fieldName, float v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectNode put(String fieldName, Float value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectNode put(String fieldName, double v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectNode put(String fieldName, Double value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectNode put(String fieldName, BigDecimal v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectNode put(String fieldName, String v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectNode put(String fieldName, boolean v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectNode put(String fieldName, Boolean value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectNode put(String fieldName, byte[] v) {
            throw new UnsupportedOperationException();
        }

        static /* synthetic */ JsonNode access$000() {
            return EmptySchema.getInstance();
        }
    }
}

