/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.util;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;

public enum NodeType {
    ARRAY("array"),
    BOOLEAN("boolean"),
    INTEGER("integer"),
    NUMBER("number"),
    NULL("null"),
    OBJECT("object"),
    STRING("string");

    private final String name;
    private static final Map<String, NodeType> nameMap;
    private static final Map<JsonToken, NodeType> reverseMap;

    private NodeType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static NodeType fromName(String name) {
        return nameMap.get(name);
    }

    public static NodeType getNodeType(JsonNode node) {
        JsonToken token = node.asToken();
        NodeType ret = reverseMap.get((Object)token);
        Preconditions.checkNotNull(ret, "unhandled token type " + (Object)((Object)token));
        return ret;
    }

    static {
        reverseMap = new EnumMap<JsonToken, NodeType>(JsonToken.class);
        reverseMap.put(JsonToken.START_ARRAY, ARRAY);
        reverseMap.put(JsonToken.VALUE_TRUE, BOOLEAN);
        reverseMap.put(JsonToken.VALUE_FALSE, BOOLEAN);
        reverseMap.put(JsonToken.VALUE_NUMBER_INT, INTEGER);
        reverseMap.put(JsonToken.VALUE_NUMBER_FLOAT, NUMBER);
        reverseMap.put(JsonToken.VALUE_NULL, NULL);
        reverseMap.put(JsonToken.START_OBJECT, OBJECT);
        reverseMap.put(JsonToken.VALUE_STRING, STRING);
        ImmutableMap.Builder<String, NodeType> builder = ImmutableMap.builder();
        for (NodeType type : NodeType.values()) {
            builder.put(type.name, type);
        }
        nameMap = builder.build();
    }
}

