/*
 * Decompiled with CFR 0.152.
 */
package org.eel.kitchen.jsonschema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.eel.kitchen.jsonschema.ref.JsonPointer;
import org.eel.kitchen.jsonschema.report.ValidationReport;
import org.eel.kitchen.jsonschema.util.JacksonUtils;
import org.eel.kitchen.jsonschema.validator.JsonValidator;
import org.eel.kitchen.jsonschema.validator.ValidationContext;

final class ArrayValidator
implements JsonValidator {
    private final JsonNode additionalItems;
    private final List<JsonNode> items;

    ArrayValidator(JsonNode schema) {
        JsonNode node = schema.path("items");
        if (!node.isArray()) {
            this.additionalItems = node.isObject() ? node : JacksonUtils.emptySchema();
            this.items = Collections.emptyList();
            return;
        }
        this.items = ImmutableList.copyOf(node);
        node = schema.path("additionalItems");
        this.additionalItems = node.isObject() ? node : JacksonUtils.emptySchema();
    }

    @Override
    public void validate(ValidationContext context, ValidationReport report, JsonNode instance) {
        JsonPointer pwd = report.getPath();
        for (int i = 0; i < instance.size(); ++i) {
            report.setPath(pwd.append(i));
            JsonNode element = instance.get(i);
            JsonNode subSchema = this.getSchema(i);
            JsonValidator validator = context.newValidator(subSchema);
            validator.validate(context, report, element);
            if (report.hasFatalError()) break;
        }
        report.setPath(pwd);
    }

    @VisibleForTesting
    JsonNode getSchema(int index) {
        return index >= this.items.size() ? this.additionalItems : this.items.get(index);
    }
}

