/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.rule;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.eel.kitchen.jsonschema.util.JsonLoader;
import org.raml.parser.rule.GlobalSchemasRule;
import org.raml.parser.rule.SimpleRule;
import org.raml.parser.rule.TupleRule;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.IncludeResolver;
import org.raml.parser.visitor.IncludeInfo;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public class SchemaRule
extends SimpleRule {
    public SchemaRule() {
        super("schema", String.class);
    }

    @Override
    public List<ValidationResult> doValidateValue(ScalarNode node) {
        String value = node.getValue();
        List<ValidationResult> validationResults = super.doValidateValue(node);
        IncludeInfo globaSchemaIncludeInfo = null;
        ScalarNode schemaNode = this.getGlobalSchemaNode(value);
        if (schemaNode == null) {
            schemaNode = node;
        } else {
            value = schemaNode.getValue();
            if (schemaNode.getTag().startsWith("!include-applied_")) {
                globaSchemaIncludeInfo = new IncludeInfo(schemaNode.getTag());
            }
        }
        if (value == null || this.isCustomTag(schemaNode.getTag())) {
            return validationResults;
        }
        String mimeType = ((ScalarNode)this.getParentTupleRule().getKey()).getValue();
        if (mimeType.contains("json")) {
            try {
                JsonLoader.fromString(value);
            }
            catch (JsonParseException jpe) {
                String msg = "invalid JSON schema" + this.getSourceErrorDetail(node) + jpe.getOriginalMessage();
                JsonLocation loc = jpe.getLocation();
                validationResults.add(this.getErrorResult(msg, this.getLineOffset(schemaNode) + loc.getLineNr(), globaSchemaIncludeInfo));
            }
            catch (IOException e) {
                String prefix = "invalid JSON schema" + this.getSourceErrorDetail(node);
                validationResults.add(this.getErrorResult(prefix + e.getMessage(), -1, globaSchemaIncludeInfo));
            }
        } else if (mimeType.contains("xml")) {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                factory.newSchema(new StreamSource(new StringReader(value)));
            }
            catch (SAXParseException e) {
                String msg = "invalid XML schema" + this.getSourceErrorDetail(node) + e.getMessage();
                validationResults.add(this.getErrorResult(msg, this.getLineOffset(schemaNode) + e.getLineNumber(), globaSchemaIncludeInfo));
            }
            catch (SAXException e) {
                String msg = "invalid XML schema" + this.getSourceErrorDetail(node);
                validationResults.add(this.getErrorResult(msg, this.getLineOffset(schemaNode), globaSchemaIncludeInfo));
            }
        }
        return validationResults;
    }

    private ValidationResult getErrorResult(String msg, int line, IncludeInfo globaSchemaIncludeInfo) {
        ValidationResult errorResult = ValidationResult.createErrorResult(msg, line, -1, -1);
        if (globaSchemaIncludeInfo != null) {
            errorResult.setExtraIncludeInfo(globaSchemaIncludeInfo);
        }
        return errorResult;
    }

    private int getLineOffset(ScalarNode schemaNode) {
        boolean isInclude = schemaNode.getTag().startsWith("!include-applied_");
        return isInclude ? -1 : schemaNode.getStartMark().getLine();
    }

    private String getSourceErrorDetail(ScalarNode node) {
        String msg = "";
        if (node instanceof IncludeResolver.IncludeScalarNode) {
            msg = " (" + ((IncludeResolver.IncludeScalarNode)node).getIncludeName() + ")";
        } else if (node.getValue().matches("\\w.*")) {
            msg = " (" + node.getValue() + ")";
        }
        return msg + ": ";
    }

    private ScalarNode getGlobalSchemaNode(String key) {
        GlobalSchemasRule schemasRule = (GlobalSchemasRule)this.getRootTupleRule().getRuleByFieldName("schemas");
        return schemasRule.getSchema(key);
    }

    private boolean isCustomTag(Tag tag) {
        return tag != null && !Tag.STR.equals(tag) && !tag.startsWith("!include-applied_");
    }

    @Override
    public TupleRule<?, ?> deepCopy() {
        this.checkClassToCopy(SchemaRule.class);
        SchemaRule copy = new SchemaRule();
        copy.setNodeRuleFactory(this.getNodeRuleFactory());
        copy.setHandler(this.getHandler());
        return copy;
    }
}

