/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.utils;

import java.lang.reflect.Constructor;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.lang.ClassUtils;
import org.raml.parser.utils.BooleanConverter;

public class ConvertUtils {
    private static BooleanConverter booleanConverter = new BooleanConverter();

    public static <T> T convertTo(String value, Class<T> type) {
        if (type.isEnum()) {
            return type.cast(Enum.valueOf(type, value.toUpperCase()));
        }
        Class clazz = type;
        if (type.isPrimitive()) {
            clazz = ClassUtils.primitiveToWrapper(type);
        }
        if (clazz.getName().equals(Boolean.class.getName())) {
            return clazz.cast(booleanConverter.convert(Boolean.class, value));
        }
        try {
            Constructor constructor = type.getConstructor(String.class);
            return constructor.newInstance(value);
        }
        catch (Exception exception) {
            return clazz.cast(org.apache.commons.beanutils.ConvertUtils.convert(value, type));
        }
    }

    public static boolean canBeConverted(String value, Class<?> type) {
        if (type.isEnum()) {
            ?[] enumConstants;
            for (Object enumConstant : enumConstants = type.getEnumConstants()) {
                if (!enumConstant.toString().equals(value.toUpperCase())) continue;
                return true;
            }
            return false;
        }
        if (type.isInstance(value)) {
            return true;
        }
        try {
            type.getConstructor(String.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            try {
                Class wrapperClass = ClassUtils.primitiveToWrapper(type);
                ConvertUtils.convertTo(value, wrapperClass);
                return true;
            }
            catch (ClassCastException e2) {
                return false;
            }
            catch (ConversionException e3) {
                return false;
            }
        }
    }
}

