/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.mozilla.universalchardet.UniversalDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamUtils.class);
    private static final String RAML_PARSER_ENCODING = "raml.parser.encoding";

    private static String getDefaultEncoding() {
        return System.getProperty(RAML_PARSER_ENCODING, "UTF-8");
    }

    public static Reader reader(InputStream stream) {
        try {
            byte[] content = IOUtils.toByteArray(stream);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(content), StreamUtils.detectEncoding(content));
            return inputStreamReader;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    public static String toString(InputStream stream) {
        try {
            byte[] content = IOUtils.toByteArray(stream);
            String encoding = StreamUtils.detectEncoding(content);
            return new String(StreamUtils.trimBom(content), encoding);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] trimBom(byte[] content) {
        int bomSize = 0;
        if (content.length > 4 && (content[0] == 0 && content[1] == 0 && content[2] == -2 && content[3] == -1 || content[0] == -1 && content[1] == -2 && content[2] == 0 && content[3] == 0)) {
            bomSize = 4;
        }
        if (content.length > 3 && bomSize == 0 && content[0] == -17 && content[1] == -69 && content[2] == -65) {
            bomSize = 3;
        }
        if (content.length > 2 && bomSize == 0 && (content[0] == -2 && content[1] == -1 || content[0] == -1 && content[1] == -2)) {
            bomSize = 2;
        }
        if (bomSize > 0) {
            LOGGER.debug(String.format("Trimming %s-byte BOM\n", bomSize));
            int trimmedSize = content.length - bomSize;
            byte[] trimmedArray = new byte[trimmedSize];
            System.arraycopy(content, bomSize, trimmedArray, 0, trimmedSize);
            return trimmedArray;
        }
        return content;
    }

    private static String detectEncoding(byte[] content) {
        UniversalDetector detector = new UniversalDetector(null);
        detector.handleData(content, 0, content.length);
        detector.dataEnd();
        String encoding = detector.getDetectedCharset();
        if (encoding != null) {
            LOGGER.debug(String.format("Detected encoding: %s\n", encoding));
        } else {
            encoding = StreamUtils.getDefaultEncoding();
            LOGGER.debug(String.format("No encoding detected, using default: %s\n", encoding));
        }
        detector.reset();
        return encoding;
    }
}

