/*
 * Decompiled with CFR 0.152.
 */
package raml.tools.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.Resource;
import org.raml.model.SecurityReference;
import org.raml.model.parameter.UriParameter;
import raml.tools.model.ActionContext;

public class ResourceContext {
    Resource resource;

    public ResourceContext(Resource resource) {
        this.resource = resource;
    }

    public String getUniqueId() {
        return DigestUtils.md5Hex(this.getParentUrl() + this.getRelativeUri());
    }

    public List<ResourceContext> getResources() {
        ArrayList<ResourceContext> resources = new ArrayList<ResourceContext>();
        for (Resource subResource : this.resource.getResources().values()) {
            resources.add(new ResourceContext(subResource));
        }
        return resources;
    }

    public String getType() {
        return this.resource.getType();
    }

    public String getDescription() {
        return this.resource.getDescription();
    }

    public String getDisplayName() {
        return this.resource.getDisplayName();
    }

    public Map<String, UriParameter> getUriParameters() {
        return this.resource.getUriParameters();
    }

    public Collection<ActionContext> getActions() {
        ArrayList<ActionContext> actions = new ArrayList<ActionContext>();
        for (Action action : this.resource.getActions().values()) {
            actions.add(new ActionContext(action));
        }
        return actions;
    }

    public String getRelativeUri() {
        return this.resource.getRelativeUri();
    }

    public String getParentUrl() {
        return this.resource.getParentUri();
    }

    public Action getAction(String name) {
        return this.resource.getAction(name);
    }

    public Resource getResource(String path) {
        return this.resource.getResource(path);
    }

    public String getUri() {
        return this.resource.getUri();
    }

    public List<SecurityReference> getSecuredBy() {
        return this.resource.getSecuredBy();
    }

    public Action getAction(ActionType name) {
        return this.resource.getAction(name);
    }

    public List<String> getIs() {
        return this.resource.getIs();
    }

    public Map<String, List<UriParameter>> getBaseUriParameters() {
        return this.resource.getBaseUriParameters();
    }
}

