/*
 * Decompiled with CFR 0.152.
 */
package raml.tools.traversal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.raml.model.Raml;
import org.raml.model.Resource;
import raml.tools.model.ApiInformation;
import raml.tools.traversal.RamlTraversalListener;

public class RamlTraversal {
    Raml raml;
    List<RamlTraversalListener> traversalListeners = new ArrayList<RamlTraversalListener>();

    public RamlTraversal(Raml raml) {
        if (raml == null) {
            throw new IllegalArgumentException("raml must not be null");
        }
        if (this.traversalListeners == null) {
            throw new IllegalArgumentException("listeners must not be null");
        }
        this.raml = raml;
    }

    public RamlTraversal withListener(RamlTraversalListener listener) {
        this.traversalListeners.add(listener);
        return this;
    }

    public void traverse() {
        this.notifyStartTraversal();
        this.notifyStartApiInformation();
        for (final Map.Entry<String, Resource> resource : this.raml.getResources().entrySet()) {
            this.eachListener(new ListenerFunction(){

                @Override
                public void apply(RamlTraversalListener listener) {
                    listener.startResource((String)resource.getKey(), (Resource)resource.getValue());
                    listener.endResource((String)resource.getKey(), (Resource)resource.getValue());
                }
            });
        }
        this.notifyEndTraversal();
    }

    private void notifyEndTraversal() {
        this.eachListener(new ListenerFunction(){

            @Override
            public void apply(RamlTraversalListener listener) {
                listener.endTraversal(RamlTraversal.this.raml);
            }
        });
    }

    private void notifyStartApiInformation() {
        this.eachListener(new ListenerFunction(){

            @Override
            public void apply(RamlTraversalListener listener) {
                listener.startApiInformation(new ApiInformation(RamlTraversal.this.raml.getTitle(), RamlTraversal.this.raml.getVersion(), RamlTraversal.this.raml.getBaseUri()));
            }
        });
    }

    private void notifyStartTraversal() {
        this.eachListener(new ListenerFunction(){

            @Override
            public void apply(RamlTraversalListener listener) {
                listener.startTraversal(RamlTraversal.this.raml);
            }
        });
    }

    public void eachListener(ListenerFunction listenerFunction) {
        for (RamlTraversalListener listener : this.traversalListeners) {
            listenerFunction.apply(listener);
        }
    }

    public static interface ListenerFunction {
        public void apply(RamlTraversalListener var1);
    }
}

