/*
 * Decompiled with CFR 0.152.
 */
package raml.tools.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SchemaContext {
    String schemaUri;
    String schemaType;
    private final Map<String, Object> schemaMap;
    String schemaName;
    String schemaDescription;
    String schemaContent;
    List<Property> properties;
    List<String> requiredProperties = new ArrayList<String>();

    public SchemaContext(String schemaName, String schemaContent) {
        this.schemaName = schemaName;
        this.schemaContent = schemaContent;
        this.schemaMap = this.schemaAsMap(schemaContent);
        this.schemaDescription = (String)this.schemaMap.get("description");
        this.schemaUri = (String)this.schemaMap.get("$schema");
        this.schemaType = (String)this.schemaMap.get("type");
        this.properties = this.readProperties(this.schemaMap);
    }

    private List<Property> readProperties(Map<String, Object> schemaMap) {
        ArrayList<Property> properties = new ArrayList<Property>();
        Map propertiesMap = (Map)schemaMap.get("properties");
        for (Map.Entry propertyEntry : propertiesMap.entrySet()) {
            PropertyDefinition propertyDefinition = this.readPropertyDefinitionFromMap((String)propertyEntry.getKey(), (Map)propertyEntry.getValue());
            properties.add(new Property((String)propertyEntry.getKey(), propertyDefinition));
        }
        this.requiredProperties.addAll(this.getRequiredProperties(schemaMap));
        return properties;
    }

    private List getRequiredProperties(Map<String, Object> schemaMap) {
        if (schemaMap.get("required") != null) {
            return (List)schemaMap.get("required");
        }
        return Collections.emptyList();
    }

    private PropertyDefinition readPropertyDefinitionFromMap(String propertyName, Map<String, Object> propertyDefinitionMap) {
        String type = (String)propertyDefinitionMap.get("type");
        String description = (String)propertyDefinitionMap.get("description");
        String reference = (String)propertyDefinitionMap.get("$ref");
        String targetType = (String)propertyDefinitionMap.get("targetType");
        return new PropertyDefinition(description, type).withName(propertyName).withReference(reference).withTargetType(targetType);
    }

    Map schemaAsMap(String schemaContent) {
        try {
            return (Map)new ObjectMapper().readValue(schemaContent, Map.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getSchemaContent() {
        return ((String)Optional.of((Object)this.schemaContent).or((Object)"")).trim();
    }

    public Map getSchemaMap() {
        return this.schemaMap;
    }

    public String getSchemaDescription() {
        return this.schemaDescription;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public String getSchemaUri() {
        return this.schemaUri;
    }

    public String getSchemaType() {
        return this.schemaType;
    }

    public String toString() {
        return "SchemaContext{schemaName='" + this.schemaName + '\'' + ", schemaContent='" + this.schemaContent + '\'' + '}';
    }

    class PropertyDefinition {
        String description;
        String type;
        int minimum;
        int maximum;
        String reference;
        String targetType;
        String name;

        public PropertyDefinition(String description, String type) {
            this.description = description;
            this.type = type;
        }

        public String getDescription() {
            return this.description;
        }

        public String getType() {
            return this.type;
        }

        public String getReference() {
            return this.reference;
        }

        public PropertyDefinition withReference(String reference) {
            this.reference = reference;
            return this;
        }

        public String getTargetType() {
            return this.targetType;
        }

        public PropertyDefinition withTargetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        public PropertyDefinition withName(String propertyName) {
            this.name = propertyName;
            return this;
        }

        public boolean getRequired() {
            return SchemaContext.this.requiredProperties.contains(this.name);
        }
    }

    static class Property {
        String name;
        PropertyDefinition definition;

        public Property(String name, PropertyDefinition definition) {
            this.name = name;
            this.definition = definition;
        }

        public String getName() {
            return this.name;
        }

        public PropertyDefinition getDefinition() {
            return this.definition;
        }
    }
}

