/*
 * Decompiled with CFR 0.152.
 */
package de.apaxo.test;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Object2CodeObjectOutputStream
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(Object2CodeObjectOutputStream.class.getName());
    private OutputStream out;

    public Object2CodeObjectOutputStream(OutputStream out) throws IOException, SecurityException {
        this.out = out;
    }

    public void writeObject(Object o) {
        this.writeObject(o, false);
    }

    public void writeObject(Object o, boolean onlyPropertiesWithMatchingField) {
        if (o == null) {
            log.warning("Given object is null.");
            return;
        }
        HashMap clazz2count = new HashMap();
        HashMap<Object, String> object2variableName = new HashMap<Object, String>();
        String name = this.writeObject(o, clazz2count, object2variableName, onlyPropertiesWithMatchingField);
        Class<?> clazz = o.getClass();
        if (this.isPrimitiveOrBoxClass(clazz)) {
            try {
                this.out.write(name.getBytes());
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Exception was thrown", e);
            }
        }
    }

    private boolean isPrimitiveOrBoxClass(Class<?> clazz) {
        return this.isPrimitiveOrBoxClass(clazz, true);
    }

    private boolean isPrimitiveOrBoxClass(Class<?> clazz, boolean checkString) {
        return clazz.isPrimitive() || clazz == Integer.class || clazz == Byte.class || clazz == Boolean.class || clazz == Short.class || clazz == Long.class || clazz == Double.class || clazz == Float.class || clazz == Character.class || clazz == String.class && checkString;
    }

    private String writeObject(Object o, Map<Class<?>, Integer> clazz2count, Map<Object, String> object2variableName, boolean onlyPropertiesWithMatchingField) {
        try {
            Class<?> clazz = o.getClass();
            if (this.isPrimitiveOrBoxClass(clazz, false)) {
                return this.formatType(clazz, o);
            }
            if (clazz == String.class) {
                return "\"" + o.toString() + "\"";
            }
            if (clazz.isEnum()) {
                return clazz.getName() + "." + ((Enum)o).name();
            }
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            clazz.getConstructor(new Class[0]);
            String beanName = this.getVariableName(clazz, clazz2count);
            object2variableName.put(o, beanName);
            this.out.write((clazz.getName() + " " + beanName + " = new " + clazz.getName() + "();\n").getBytes());
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                if (onlyPropertiesWithMatchingField) {
                    try {
                        clazz.getDeclaredField(propertyDescriptor.getName());
                    }
                    catch (NoSuchFieldException e) {
                        log.info("Skipping method without matching field: " + propertyDescriptor.getName());
                        continue;
                    }
                }
                Class<?> propertyClass = propertyDescriptor.getPropertyType();
                Object propertyValue = propertyDescriptor.getReadMethod().invoke(o, new Object[0]);
                if (propertyValue == null) continue;
                if (propertyClass.isPrimitive()) {
                    Method writeMethod = propertyDescriptor.getWriteMethod();
                    if (writeMethod != null) {
                        this.out.write((beanName + "." + writeMethod.getName() + "(" + this.formatType(propertyClass, propertyValue) + ");\n").getBytes());
                        continue;
                    }
                    log.warning("Can not find write method for: " + o.getClass().getName() + " " + propertyDescriptor.getName());
                    continue;
                }
                if (propertyClass == String.class) {
                    this.out.write((beanName + "." + propertyDescriptor.getWriteMethod().getName() + "(\"" + propertyValue + "\");\n").getBytes());
                    continue;
                }
                if (Collection.class.isAssignableFrom(propertyClass)) {
                    Collection collection = (Collection)propertyValue;
                    Class<?> collectionImplementation = collection.getClass();
                    String collectionName = this.getVariableName(collectionImplementation, clazz2count);
                    object2variableName.put(collection, collectionName);
                    this.out.write((collectionImplementation.getName() + " " + collectionName + " = new " + collectionImplementation.getName() + "();\n").getBytes());
                    for (Object e : collection) {
                        String itemName = this.writeObject(e, clazz2count, object2variableName, onlyPropertiesWithMatchingField);
                        this.out.write((collectionName + ".add(" + itemName + ");\n").getBytes());
                    }
                    this.out.write((beanName + "." + propertyDescriptor.getWriteMethod().getName() + "(" + collectionName + ");\n").getBytes());
                    continue;
                }
                if (Map.class.isAssignableFrom(propertyClass)) {
                    Map map = (Map)propertyValue;
                    Class<?> mapImplementation = map.getClass();
                    String mapName = this.getVariableName(mapImplementation, clazz2count);
                    object2variableName.put(map, mapName);
                    this.out.write((mapImplementation.getName() + " " + mapName + " = new " + mapImplementation.getName() + "();\n").getBytes());
                    for (Map.Entry entry : map.entrySet()) {
                        String keyName = object2variableName.containsKey(entry.getKey()) ? object2variableName.get(entry.getKey()) : this.writeObject(entry.getKey(), clazz2count, object2variableName, onlyPropertiesWithMatchingField);
                        String valueName = object2variableName.containsKey(entry.getValue()) ? object2variableName.get(entry.getValue()) : this.writeObject(entry.getValue(), clazz2count, object2variableName, onlyPropertiesWithMatchingField);
                        this.out.write((mapName + ".put(" + keyName + ", " + valueName + ");\n").getBytes());
                    }
                    this.out.write((beanName + "." + propertyDescriptor.getWriteMethod().getName() + "(" + mapName + ");\n").getBytes());
                    continue;
                }
                if (propertyClass == Class.class) continue;
                String newBeanName = object2variableName.containsKey(propertyValue) ? object2variableName.get(propertyValue) : this.writeObject(propertyValue, clazz2count, object2variableName, onlyPropertiesWithMatchingField);
                Method writeMethod = propertyDescriptor.getWriteMethod();
                if (writeMethod != null) {
                    this.out.write((beanName + "." + propertyDescriptor.getWriteMethod().getName() + "(" + newBeanName + ");\n").getBytes());
                    continue;
                }
                log.warning("Can not find write method for: " + o.getClass().getName() + " " + propertyDescriptor.getName());
            }
            return beanName;
        }
        catch (IntrospectionException e) {
            log.log(Level.WARNING, "Exception was thrown", e);
        }
        catch (NoSuchMethodException e) {
            log.log(Level.WARNING, "Exception was thrown", e);
        }
        catch (SecurityException e) {
            log.log(Level.WARNING, "Exception was thrown", e);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Exception was thrown", e);
        }
        catch (IllegalAccessException e) {
            log.log(Level.WARNING, "Exception was thrown", e);
        }
        catch (IllegalArgumentException e) {
            log.log(Level.WARNING, "Exception was thrown", e);
        }
        catch (InvocationTargetException e) {
            log.log(Level.WARNING, "Exception was thrown", e);
        }
        throw new RuntimeException("Could not serialize the given object to code. Please see the warnings in the log.");
    }

    private String formatType(Class<?> clazz, Object value) {
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return "(byte) " + value;
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return "'" + value + "'";
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return "(short)" + value;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return value + "l";
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return value + "f";
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return value.toString();
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return value.toString();
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return value.toString();
        }
        throw new IllegalArgumentException("Type " + clazz.getName() + " is not a supported primitive type.");
    }

    private String getVariableName(Class<?> clazz, Map<Class<?>, Integer> clazz2count) {
        int count = 0;
        if (clazz2count.containsKey(clazz)) {
            count = clazz2count.get(clazz);
            clazz2count.put(clazz, ++count);
        } else {
            clazz2count.put(clazz, count);
        }
        return Introspector.decapitalize(clazz.getSimpleName()) + count;
    }

    @Override
    public void close() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Exception was thrown", e);
        }
    }
}

