/*
 * Decompiled with CFR 0.152.
 */
package de.apaxo.test;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mockito.MockSettings;
import org.mockito.MockingDetails;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class CachingSpy
implements Answer<Object> {
    private static final Logger log = Logger.getLogger(CachingSpy.class.getName());
    private static CachingSpy CACHING_SPY_ANSWERS = new CachingSpy();
    private static Map<Object, Map<Method, Boolean>> shouldClassMethodBeCached = new HashMap<Object, Map<Method, Boolean>>();
    private static Map<Method, FileNameConstructor> methods2fileNameConstructor = new HashMap<Method, FileNameConstructor>();

    private CachingSpy() {
    }

    public static <T> T cachingSpy(T object) {
        return CachingSpy.cachingSpy(object, null);
    }

    public static <T> T cachingSpy(T object, Method[] methodsToCache) {
        MockingDetails mockingDetails = Mockito.mockingDetails(object);
        if (mockingDetails.isMock() || mockingDetails.isSpy()) {
            throw new IllegalArgumentException("The object that you supplied " + object + " is already a mock." + " Please create a new one.");
        }
        Class<?> clazz = object.getClass();
        Object spiedObject = Mockito.mock(clazz, (MockSettings)Mockito.withSettings().spiedInstance(object).defaultAnswer((Answer)CACHING_SPY_ANSWERS));
        CachingSpy.addMethodsToSpiedAndCachedMethods(methodsToCache, clazz, spiedObject);
        return (T)spiedObject;
    }

    private static <T> void addMethodsToSpiedAndCachedMethods(Method[] methodsToCache, Class<T> clazz, T spiedObject) {
        if (methodsToCache == null) {
            methodsToCache = clazz.getMethods();
        }
        for (Method method : methodsToCache) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            Map<Method, Boolean> shouldMethodBeCached = shouldClassMethodBeCached.get(spiedObject);
            if (shouldMethodBeCached == null) {
                shouldMethodBeCached = new HashMap<Method, Boolean>();
                shouldClassMethodBeCached.put(spiedObject, shouldMethodBeCached);
            }
            log.fine("Intercepting " + method.getName() + " on " + clazz.getName() + " instance: " + spiedObject);
            shouldMethodBeCached.put(method, true);
        }
    }

    public static <T extends K, K> K cachingSpyForFinalClass(Class<K> clazz, T object) {
        return CachingSpy.cachingSpyForFinalClass(clazz, object, null);
    }

    public static <T extends K, K> K cachingSpyForFinalClass(Class<K> clazz, final T object, Method[] methodsToCache) {
        MockingDetails mockingDetails = Mockito.mockingDetails(object);
        if (mockingDetails.isMock() || mockingDetails.isSpy()) {
            throw new IllegalArgumentException("The object that you supplied " + object + " is already a mock." + " Please create a new one.");
        }
        Object spiedObject = Mockito.mock(clazz, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                if (!shouldClassMethodBeCached.containsKey(invocation.getMock()) || !((Map)shouldClassMethodBeCached.get(invocation.getMock())).containsKey(invocation.getMethod())) {
                    Method methodOnRealObject = object.getClass().getMethod(invocation.getMethod().getName(), invocation.getMethod().getParameterTypes());
                    return methodOnRealObject.invoke(object, invocation.getArguments());
                }
                String fileName = CachingSpy.generateFileNameForInvocation(invocation);
                Object returnValue = CachingSpy.tryToFindFileAndUnserialize(fileName);
                if (returnValue == null) {
                    Method methodOnRealObject = object.getClass().getMethod(invocation.getMethod().getName(), invocation.getMethod().getParameterTypes());
                    returnValue = methodOnRealObject.invoke(object, invocation.getArguments());
                    log.fine("Saving anwser to call to file: " + fileName);
                    CachingSpy.serializeAndSaveToFile(fileName, returnValue);
                } else {
                    log.fine("Reading anwser for call from file: " + fileName);
                }
                return returnValue;
            }
        }));
        CachingSpy.addMethodsToSpiedAndCachedMethods(methodsToCache, clazz, spiedObject);
        return (K)spiedObject;
    }

    public Object answer(InvocationOnMock invocation) throws Throwable {
        if (!shouldClassMethodBeCached.containsKey(invocation.getMock()) || !shouldClassMethodBeCached.get(invocation.getMock()).containsKey(invocation.getMethod())) {
            return invocation.callRealMethod();
        }
        String fileName = CachingSpy.generateFileNameForInvocation(invocation);
        Object returnValue = CachingSpy.tryToFindFileAndUnserialize(fileName);
        if (returnValue == null) {
            returnValue = invocation.callRealMethod();
            log.fine("Saving anwser to call to file: " + fileName);
            CachingSpy.serializeAndSaveToFile(fileName, returnValue);
        } else {
            log.fine("Reading anwser for call from file: " + fileName);
        }
        return returnValue;
    }

    private static void serializeAndSaveToFile(String fileName, Object returnValue) {
        try {
            File directory = new File(CachingSpy.class.getClassLoader().getResource("").toURI());
            File newFile = new File(directory, fileName);
            ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(newFile)));
            out.writeObject(returnValue);
            out.close();
        }
        catch (URISyntaxException e) {
            log.log(Level.SEVERE, "Exception was thrown", e);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Exception was thrown", e);
        }
    }

    private static Object tryToFindFileAndUnserialize(String fileName) {
        File file;
        URL fileURL = CachingSpy.class.getClassLoader().getResource(fileName);
        if (fileURL == null) {
            log.fine("Did not find file name: " + fileName);
            return null;
        }
        try {
            file = new File(fileURL.toURI());
        }
        catch (URISyntaxException e1) {
            log.log(Level.SEVERE, "Exception was thrown", e1);
            return null;
        }
        try {
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            Object o = in.readObject();
            in.close();
            return o;
        }
        catch (FileNotFoundException e) {
            log.log(Level.FINE, "Exception was thrown", e);
            return null;
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Exception was thrown", e);
            return null;
        }
        catch (ClassNotFoundException e) {
            log.log(Level.SEVERE, "Exception was thrown", e);
            return null;
        }
    }

    private static String generateFileNameForInvocation(InvocationOnMock invocation) {
        Method method = invocation.getMethod();
        Class<?> clazz = method.getDeclaringClass();
        String fileName = clazz.getName() + "-" + method.getName();
        if (methods2fileNameConstructor.containsKey(invocation.getMethod())) {
            fileName = fileName + "-" + methods2fileNameConstructor.get(invocation.getMethod()).generateFileName(invocation.getArguments());
        } else {
            int hashCode = Arrays.deepHashCode(invocation.getArguments());
            fileName = fileName + "-" + hashCode;
        }
        fileName = fileName + ".dat";
        return fileName;
    }

    public static void addFileNameConstructor(Method method, FileNameConstructor fileNameConstructor) {
        methods2fileNameConstructor.put(method, fileNameConstructor);
    }

    public static void removeFileNameConstructor(Method method) {
        methods2fileNameConstructor.remove(method);
    }

    public static interface FileNameConstructor {
        public String generateFileName(Object[] var1);
    }
}

