package de.audiophobe;

import java.util.ArrayList;
import java.util.List;

public class CalciferPage extends CalciferPart {

  private List<CalciferPart> parts = new ArrayList<>();
  private String pageName;
  private String filename;

  public CalciferPage(String pageName) {
    super();
    setPageName(pageName);
  }

  public List<CalciferPart> getParts() {
    return parts;
  }

  public void setParts(List<CalciferPart> parts) {
    this.parts = parts;
  }

  public void setFilename(String filename) {
    this.filename = filename;
  }

  public String getPageName() {
    return pageName;
  }

  public void setPageName(String pageName) {
    this.pageName = pageName;

    if (pageName.equals(CalciferProject.TOP)) {
      filename = "top-level-page.adoc";
    } else {
      filename = pageName.replaceAll("[^a-zA-z0-9\\.]", "_") + ".adoc";
    }
  }

  public String getFilename() {
    return filename;
  }

  @Override
  public List<String> getContents(boolean isFragment, CalciferProject calciferProject) {
    List<String> result = new ArrayList<>();

    for (CalciferPart part : parts) {
      List<String> partLines = part.getContents(isFragment,calciferProject);
      result.addAll(partLines);
      result.add("");
    }
    return result;
  }
}
