package de.audiophobe;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class CalciferPart {

  private final static AtomicInteger sequence = new AtomicInteger(100000);
  protected String id;

  public static String getNextBlockId() {
    return "b" + sequence.incrementAndGet();
  }

  public abstract List<String> getContents(boolean isFragment, CalciferProject calciferProject);

  public void addIdIfNull() {
    if (id == null) {
      id = getNextBlockId();
    }
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }
}
