package de.audiophobe.test;

import java.util.Arrays;
import java.util.List;

public enum ClarificationTypeE {
  // Klärfälle auf Liegenschaftsebene
  TERMIN_PRUEFEN(null, "Termin prüfen", "042"),

  A_SATZ_PRUEFEN(null, "A-Satz prüfen", "039"),

  MONTAGEDOKU_PRUEFEN(null, "Montage Dokumentation ist in der Validierung von Gewobag", "055"),

  // Klärfälle auf Geräteebene
  KLEIN_REPERATUR("KLEINREP", "Einbauvorauss. herst. durch KRM", "045"),

  BAUMASSNAHME("BAUMASS", "Einbauvorauss. herst. durch baul. Maßn.", "044"),

  MIETERVERSCHULDEN("MIETVER", "Einbauvorauss. herst., Mieterverschulden", "043"),

  EINBAU_VERWEIGERT("EINVER", "Mieter verweigert Einbau", "033"),

  /**
   * Wird im Gerätetausch Prozess genutzt, kann aber auch über das Frontend angelegt werden.
   */
  GESONDERTE_BEAUFTRAGUNG(null, "MDL gesonderte Beauftragung notwendig", "059"),

  // Wohnungsebene Pseudo-Klärfalltypen (Infoschlüssel)
  ZUTRITT_VERWEIGERT("EINVER", "Mieter verweigert Zutritt zur Wohnung", "033"),

  ABWESEND("ABWESEND", "Mieter nicht angetroffen. Pseudo-Eintrag um NE-Infoschlüssel zu erkennen", null),

  // Weitere genutzte Klärfalltypen
  PLANTERMIN_KORRIGIEREN(null, "Plantermin korrigieren", "041"),

  UNTERSTUETZUNG_AUFTRAGNEHMER(null, "Unterstützung Auftragnehmer notwendig", "047"),

  MIETERBELASTUNG(null, "MBL erforderlich", "036"),

  ZUSAETZLICHE_ANFAHRT(null, "MDL zusätzliche Anfahrt", "052"),

  // Aus dem Code nicht genutzt, für das Mapping fürs Frontend da
  UNTERSTUETZUNG_AUFTRAGGEBER("", "Unterstützung Auftraggeber notwendig (Gewobag-interner KF)", "046"),

  UNTERSTUETZUNG_AUFTRAGGEBER_EXTERN("UNTERSTUETZUNG_AUFTRAGGEBER_EXTERN", "Unterstützung Auftraggeber notwendig (von MDL angelegt)",
      "015"),

  FEHLER_ANLAGE_STAMMDATEN(null, "Fehler beim Anlegen der Stammdaten", "057"),

  MDL_KUNDENINFO_OHNE_RUECKANTWORT(null, "MDL - Kundeninformation ohne Rückantwort", "064"),

  MDL_KUNDENINFO_MIT_RUECKANTWORT(null, "MDL - Kundeninformation mit Rückantwort", "065"),

  EINBAUVORAUSSETZUNGEN_WERDEN_HERGESTELLT(null, "Einbauvoraussetzungen werden hergestellt", "050"),

  ZUSATZ_ANFAHRT_MIETERVERSCHULDEN(null, "Zusätzliche Anfahrt Mieterverschulden", "066"),

  UNBEKANNT(null, "Klärfalltyp ist unbekannt", null);

  /**
   * ///.Nur diese unterbrechenden Klärfalltypen dürfen aus dem Frontend angelegt werden
   * ///* MIETERBELASTUNG
   * ///* UNTERSTUETZUNG_AUFTRAGGEBER_EXTERN
   * ///* ZUSAETZLICHE_ANFAHRT
   * ///* MIETERVERSCHULDEN
   * ///* KLEIN_REPERATUR
   * ///* EINBAU_VERWEIGERT
   * ///* ZUSATZ_ANFAHRT_MIETERVERSCHULDEN
   * ///* BAUMASSNAHME
   */
  public static final List<ClarificationTypeE> VALID_INTERRUPTING_CLARIFICATION_TYPES = Arrays.asList(
      new ClarificationTypeE[]{ClarificationTypeE.MIETERBELASTUNG,
          ClarificationTypeE.UNTERSTUETZUNG_AUFTRAGGEBER_EXTERN,
          ClarificationTypeE.ZUSAETZLICHE_ANFAHRT,
          ClarificationTypeE.MIETERVERSCHULDEN,
          ClarificationTypeE.KLEIN_REPERATUR,
          ClarificationTypeE.EINBAU_VERWEIGERT,
          ClarificationTypeE.ZUSATZ_ANFAHRT_MIETERVERSCHULDEN,
          ClarificationTypeE.BAUMASSNAHME});
  /**
   * ///.Nur diese nicht unterbrechenden Klärfalltypen dürfen aus dem Frontend angelegt werden
   * ///* GESONDERTE_BEAUFTRAGUNG
   * ///* MDL_KUNDENINFO_OHNE_RUECKANTWORT
   */
  public static final List<ClarificationTypeE> VALID_NON_INTERRUPTING_CLARIFICATION_TYPES = Arrays.asList(
      new ClarificationTypeE[]{ClarificationTypeE.GESONDERTE_BEAUFTRAGUNG,
          ClarificationTypeE.MDL_KUNDENINFO_OHNE_RUECKANTWORT});


  private String id = null;
  private String text = null;
  private String gewobagClaryId = null;
  ;

  ClarificationTypeE(String id, String text, String gewobagClaryId) {
    this.gewobagClaryId = gewobagClaryId;
    this.id = id;
    this.text = text;
  }


}
