/*
 * Decompiled with CFR 0.152.
 */
package de.audiophobe;

import de.audiophobe.CalciferPart;
import de.audiophobe.CalciferProject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class CalciferEnum
extends CalciferPart {
    private String classname;
    private String classnameTranslated;
    private List<String> fields = new ArrayList<String>();
    private ClassLoader classLoader;

    public Object getValueIncludingSuperclasses(String fieldName, Object o) {
        try {
            Field field = null;
            try {
                field = o.getClass().getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                return this.getValueIncludingSuperclasses(fieldName, o.getClass().getSuperclass());
            }
            field.setAccessible(true);
            Object val = field.get(o);
            return val;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> getContents(boolean isFragment, CalciferProject calciferProject) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("== " + this.classname);
        String header = "[cols=\"";
        header = header + this.fields.stream().collect(Collectors.joining(","));
        header = header + "\"]";
        result.add(header);
        result.add("|===");
        header = "|" + this.fields.stream().collect(Collectors.joining("|"));
        result.add(header);
        try {
            ?[] enumConst;
            Class<?> c = this.classLoader.loadClass(this.classname);
            for (Object o : enumConst = c.getEnumConstants()) {
                result.add("");
                String row = "";
                for (String field : this.fields) {
                    Object val = this.getValueIncludingSuperclasses(field, o);
                    if (val == null) {
                        row = row + "|";
                        continue;
                    }
                    if (!(val instanceof String)) continue;
                    row = row + "|" + (String)val;
                }
                result.add(row);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        result.add("|===");
        return result;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
        this.classnameTranslated = classname.replace(".", "\\") + ".class";
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public String getClassnameTranslated() {
        return this.classnameTranslated;
    }

    public void setClassnameTranslated(String classnameTranslated) {
        this.classnameTranslated = classnameTranslated;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

