/*
 * Decompiled with CFR 0.152.
 */
package de.audiophobe;

import de.audiophobe.CalciferBlock;
import de.audiophobe.CalciferCodeLine;
import de.audiophobe.CalciferCodeStateE;
import de.audiophobe.CalciferDiagram;
import de.audiophobe.CalciferEnum;
import de.audiophobe.CalciferPage;
import de.audiophobe.CalciferPart;
import de.audiophobe.CalciferProject;
import de.audiophobe.CalciferUtil;
import de.audiophobe.DiagramLine;
import de.audiophobe.EnumLine;
import de.audiophobe.parser.JavaClassParser;
import de.audiophobe.parser.JavaSourceParser;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="parse", requiresDependencyResolution=ResolutionScope.TEST)
public class CalciferMojo
extends AbstractMojo {
    public static final String INCLUDE = "TIP: IMPORT HERE ";
    public static final String INCLUDE_FRAGMENT = "TIP: IMPORT FRAGMENT HERE ";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    private ClassLoader extendedLoader = null;
    public static List<String> ENCODINGS = Arrays.asList("UTF-8", "ISO-8859-1", "windows-1250");
    private List<File> allFiles = new ArrayList<File>();

    public boolean isValidFile(File f) {
        return f.isFile() && f.exists() && f.length() > 0L && (f.getName().endsWith(".java") || f.getName().endsWith(".properties"));
    }

    public boolean isValidDirectory(File f) {
        return f.isDirectory() && !f.getName().startsWith(".git") && !f.getName().startsWith("target") && !f.getName().startsWith(".idea");
    }

    public void listFiles(File root) {
        List<File> workDir = Arrays.asList(root.listFiles());
        for (File f : workDir) {
            if (this.isValidFile(f)) {
                this.allFiles.add(f);
                continue;
            }
            if (!this.isValidDirectory(f)) continue;
            this.listFiles(f);
        }
    }

    public void execute() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("Running in Basedir " + this.project.getBasedir().getAbsolutePath()));
            this.addClasspath();
            this.listFiles(this.project.getBasedir());
            this.createMarkup();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLog().error((CharSequence)"Error in execution", (Throwable)e);
            throw new MojoExecutionException("Error execution", e);
        }
    }

    public String extractPage(String s) {
        String regex = "p=(.*)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(s);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public String extractBlockMarker(String s) {
        String regex = "b=(.*)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(s);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public String extractCodeBlockMarker(String s) {
        String regex = "cb=(.*)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(s);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public String extractIncludeMarker(String s) {
        String regex = "i=(.*)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(s);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public DiagramLine extractDiagramLine(String s) {
        String regex = "(dl?)=(.*)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(s);
        if (matcher.matches()) {
            String directive = matcher.group(1);
            String[] data = matcher.group(2).split(";");
            if (directive.equals("d")) {
                DiagramLine diagramLine = new DiagramLine();
                diagramLine.diagramName = data[0];
                diagramLine.line = data[1];
                return diagramLine;
            }
            DiagramLine diagramLine = new DiagramLine();
            diagramLine.diagramName = null;
            diagramLine.line = data[0];
            return diagramLine;
        }
        return null;
    }

    public EnumLine extractEnumLine(String s) {
        String regex = "enum=(.*);(.*)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(s);
        if (matcher.matches()) {
            EnumLine line = new EnumLine();
            line.enumName = matcher.group(1);
            line.fields = matcher.group(2);
            return line;
        }
        return null;
    }

    public void createMarkupForFile(File f, CalciferProject calciferProject) {
        boolean headerCreated = false;
        this.getLog().info((CharSequence)("Create markup for " + f.getAbsolutePath()));
        ArrayList allBlocks = new ArrayList();
        List<String> lines = CalciferUtil.INSTANCE.readAllLines(f, this.getLog());
        try {
            ArrayList allComments = new ArrayList();
            JavaSourceParser javaSourceParser = new JavaSourceParser();
            List<CalciferCodeLine> allCodeLines = javaSourceParser.extractLines(f, this.getLog());
            CalciferCodeStateE state = CalciferCodeStateE.NONE;
            CalciferBlock currentBlock = new CalciferBlock();
            String currentPage = "top";
            String currentBlockMarker = null;
            String currentDiagramName = null;
            for (CalciferCodeLine cl : allCodeLines) {
                String c = cl.getParseRemoveSpace();
                if (c != null) {
                    String page = this.extractPage(c);
                    String block = this.extractBlockMarker(c);
                    String codeblock = this.extractCodeBlockMarker(c);
                    String includeMarker = this.extractIncludeMarker(c);
                    DiagramLine diagramLine = this.extractDiagramLine(c);
                    EnumLine enumLine = this.extractEnumLine(c);
                    if (enumLine != null) {
                        CalciferEnum calciferEnum = calciferProject.getEnum(enumLine.enumName);
                        calciferEnum.setClassname(enumLine.enumName);
                        calciferEnum.setFields(Arrays.asList(enumLine.fields.split(",")));
                        calciferEnum.setClassLoader(this.extendedLoader);
                        continue;
                    }
                    if (includeMarker != null) {
                        currentBlock.add(INCLUDE + includeMarker);
                        continue;
                    }
                    if (diagramLine != null) {
                        if (diagramLine.diagramName != null) {
                            currentDiagramName = diagramLine.diagramName;
                        } else {
                            diagramLine.diagramName = currentDiagramName;
                        }
                        CalciferDiagram calciferDiagram = calciferProject.getDiagram(currentDiagramName);
                        calciferDiagram.add(diagramLine.line);
                        this.getLog().info((CharSequence)("Diagram: " + currentDiagramName + ", line: " + diagramLine.line));
                        continue;
                    }
                    if (block != null) {
                        state = CalciferCodeStateE.BLOCK;
                        currentBlockMarker = block;
                        currentBlock = calciferProject.getBlock(currentBlockMarker);
                        continue;
                    }
                    if (codeblock != null) {
                        state = CalciferCodeStateE.CODEBLOCK;
                        currentBlockMarker = codeblock;
                        currentBlock = calciferProject.getBlock(currentBlockMarker);
                        currentBlock.add("....");
                        continue;
                    }
                    if (page != null) {
                        currentPage = page;
                        continue;
                    }
                    if (state == CalciferCodeStateE.CODEBLOCK) {
                        currentBlock.add(cl.getParseWithSpace());
                        continue;
                    }
                    currentBlock.add(c);
                    continue;
                }
                if (currentBlock.isEmpty()) continue;
                if (state == CalciferCodeStateE.CODEBLOCK) {
                    currentBlock.add("....");
                }
                if (currentBlockMarker != null) {
                    calciferProject.blocks.put(currentBlockMarker, currentBlock);
                } else {
                    calciferProject.addBlockToPage(currentPage, currentBlock);
                }
                currentBlock = new CalciferBlock();
                state = CalciferCodeStateE.NONE;
                currentBlockMarker = null;
            }
            if (!currentBlock.isEmpty()) {
                calciferProject.addBlockToPage(currentPage, currentBlock);
            }
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new RuntimeException(e);
        }
        this.getLog().info((CharSequence)("Done with " + f.getAbsolutePath()));
    }

    public void writePage(File dir, String filename, String content) {
        dir.mkdirs();
        File f = new File(dir, filename);
        try {
            Files.write(f.toPath(), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String replaceFields(String s, CalciferProject calciferProject) {
        String result = s;
        List<String> placeholders = this.getPlaceholders(result);
        if (result != null && !placeholders.isEmpty()) {
            for (String ph : placeholders) {
                String toReplace = "${" + ph + "}";
                this.getLog().info((CharSequence)("Check placeholder " + toReplace));
                CalciferPart calciferPart = calciferProject.findPart(ph);
                if (calciferPart == null) continue;
                String replaceWith = calciferPart.getContents(true, calciferProject).stream().collect(Collectors.joining("\n"));
                this.getLog().info((CharSequence)("Replace " + toReplace + " with " + replaceWith));
                result = result.replace(toReplace, replaceWith);
            }
        }
        return result;
    }

    public List<String> getPlaceholders(String s) {
        ArrayList<String> result = new ArrayList<String>();
        if (s != null && !s.isEmpty()) {
            String pattern = "\\$\\{([^\\}]+)\\}";
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(s);
            while (m.find()) {
                String ph = m.group(1);
                this.getLog().info((CharSequence)("Found placeholder " + ph));
                result.add(ph);
            }
        }
        return result;
    }

    public void generateMarkup(CalciferProject calciferProject) {
        for (String pageName : calciferProject.pages.keySet()) {
            boolean include;
            this.getLog().info((CharSequence)("Generate markup f\u00fcr pageName " + pageName));
            CalciferPage calciferPage = calciferProject.getPage(pageName);
            File dir = null;
            if (pageName.equals("top")) {
                dir = calciferProject.rootDir;
            } else {
                dir = new File(calciferProject.rootDir, "top-level-page");
                dir.mkdirs();
            }
            String title = calciferPage.getPageName();
            String filename = calciferPage.getFilename();
            StringBuilder sb = new StringBuilder();
            sb.append("= " + title + "\n\n");
            List<String> allContent = calciferPage.getContents(false, calciferProject);
            do {
                ArrayList<String> allContentCollected = new ArrayList<String>();
                include = false;
                for (String line : allContent) {
                    List<String> partContent;
                    CalciferPart part;
                    String partId;
                    if (line.startsWith(INCLUDE)) {
                        partId = line.replace(INCLUDE, "");
                        this.getLog().info((CharSequence)("Include " + partId));
                        part = calciferProject.findPart(partId);
                        partContent = part.getContents(false, calciferProject);
                        allContentCollected.addAll(partContent);
                        this.getLog().info((CharSequence)("Added " + partContent.size() + " from " + partId));
                        include = true;
                        continue;
                    }
                    if (line.startsWith(INCLUDE_FRAGMENT)) {
                        partId = line.replace(INCLUDE_FRAGMENT, "");
                        this.getLog().info((CharSequence)("Include fragment " + partId));
                        part = calciferProject.findPart(partId);
                        partContent = part.getContents(true, calciferProject);
                        allContentCollected.addAll(partContent);
                        this.getLog().info((CharSequence)("Added " + partContent.size() + " from " + partId));
                        include = true;
                        continue;
                    }
                    String replacedFields = this.replaceFields(line, calciferProject);
                    allContentCollected.add(replacedFields);
                    if (line.equals(replacedFields)) continue;
                    include = true;
                }
                allContent = allContentCollected;
            } while (include);
            for (String line : allContent) {
                sb.append(line);
                sb.append("\n");
            }
            String content = sb.toString();
            this.writePage(dir, filename, content);
        }
    }

    boolean deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                this.deleteDirectory(file);
            }
        }
        return directoryToBeDeleted.delete();
    }

    public void createMarkup() {
        StringBuilder sb = new StringBuilder();
        File rootDir = new File(this.project.getBasedir(), "/confluence");
        if (rootDir.exists()) {
            try {
                this.deleteDirectory(rootDir);
            }
            catch (Exception e) {
                this.getLog().error((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        sb.append("= Generierte Doku zu " + this.project.getName() + "\n");
        CalciferProject calciferProject = new CalciferProject();
        calciferProject.rootDir = rootDir;
        calciferProject.title = this.project.getName();
        JavaClassParser classParser = new JavaClassParser();
        for (File f : this.allFiles) {
            classParser.parseClass(f, calciferProject, this.getLog(), this.extendedLoader);
        }
        for (File f : this.allFiles) {
            this.createMarkupForFile(f, calciferProject);
        }
        this.generateMarkup(calciferProject);
    }

    public void addClasspath() {
        try {
            HashSet<URL> urls = new HashSet<URL>();
            HashSet elements = new HashSet();
            elements.addAll(this.project.getCompileClasspathElements());
            elements.addAll(this.project.getRuntimeClasspathElements());
            elements.addAll(this.project.getTestClasspathElements());
            this.getLog().info((CharSequence)"Check deps");
            for (Dependency dependency : this.project.getDependencies()) {
                this.getLog().info((CharSequence)dependency.getSystemPath());
                this.getLog().info((CharSequence)("A:" + dependency.getArtifactId()));
            }
            for (String element : elements) {
                this.getLog().info((CharSequence)("Add Classpath Element: " + element));
                urls.add(new File(element).toURI().toURL());
            }
            this.extendedLoader = URLClassLoader.newInstance(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

