/*
 * Decompiled with CFR 0.152.
 */
package de.audiophobe;

import de.audiophobe.CalciferPart;
import de.audiophobe.CalciferProject;
import java.util.ArrayList;
import java.util.List;

public class CalciferPage
extends CalciferPart {
    private List<CalciferPart> parts = new ArrayList<CalciferPart>();
    private String pageName;
    private String filename;

    public CalciferPage(String pageName) {
        this.setPageName(pageName);
    }

    public List<CalciferPart> getParts() {
        return this.parts;
    }

    public void setParts(List<CalciferPart> parts) {
        this.parts = parts;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getPageName() {
        return this.pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
        this.filename = pageName.equals("top") ? "top-level-page.adoc" : pageName.replaceAll("[^a-zA-z0-9\\.]", "_") + ".adoc";
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public List<String> getContents(boolean isFragment, CalciferProject calciferProject) {
        ArrayList<String> result = new ArrayList<String>();
        for (CalciferPart part : this.parts) {
            List<String> partLines = part.getContents(isFragment, calciferProject);
            result.addAll(partLines);
            result.add("");
        }
        return result;
    }
}

