/*
 * Decompiled with CFR 0.152.
 */
package de.audiophobe;

import de.audiophobe.CalciferBlock;
import de.audiophobe.CalciferDiagram;
import de.audiophobe.CalciferEnum;
import de.audiophobe.CalciferField;
import de.audiophobe.CalciferPage;
import de.audiophobe.CalciferPart;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class CalciferProject {
    public static final String TOP = "top";
    public File rootDir;
    public String title;
    public Map<String, CalciferPage> pages = new HashMap<String, CalciferPage>();
    public Map<String, CalciferBlock> blocks = new HashMap<String, CalciferBlock>();
    public Map<String, CalciferDiagram> diagrams = new HashMap<String, CalciferDiagram>();
    public Map<String, CalciferEnum> enums = new HashMap<String, CalciferEnum>();
    public Map<String, CalciferField> fields = new HashMap<String, CalciferField>();

    public CalciferProject() {
        this.pages.put(TOP, new CalciferPage(TOP));
    }

    public CalciferPage getPage(String pageName) {
        this.pages.putIfAbsent(pageName, new CalciferPage(pageName));
        return this.pages.get(pageName);
    }

    public CalciferBlock getBlock(String name) {
        this.blocks.putIfAbsent(name, new CalciferBlock(name));
        return this.blocks.get(name);
    }

    public CalciferField getField(String id) {
        this.fields.putIfAbsent(id, new CalciferField(id));
        return this.fields.get(id);
    }

    public CalciferDiagram getDiagram(String name) {
        this.diagrams.putIfAbsent(name, new CalciferDiagram(name));
        CalciferDiagram calciferDiagram = this.diagrams.get(name);
        calciferDiagram.setName(name);
        return this.diagrams.get(name);
    }

    public CalciferEnum getEnum(String name) {
        this.enums.putIfAbsent(name, new CalciferEnum());
        CalciferEnum calciferEnum = this.enums.get(name);
        return calciferEnum;
    }

    public void addBlockToPage(String pageName, CalciferBlock block) {
        CalciferPage calciferPage = this.getPage(pageName);
        block.addIdIfNull();
        calciferPage.getParts().add(block);
        this.blocks.put(block.getId(), block);
    }

    public CalciferPart findPart(String id) {
        if (this.blocks.containsKey(id)) {
            return this.blocks.get(id);
        }
        if (this.enums.containsKey(id)) {
            return this.enums.get(id);
        }
        if (this.diagrams.containsKey(id)) {
            return this.diagrams.get(id);
        }
        if (this.fields.containsKey(id)) {
            return this.fields.get(id);
        }
        return null;
    }
}

