/*
 * Decompiled with CFR 0.152.
 */
package de.audiophobe.parser;

import de.audiophobe.CalciferProject;
import de.audiophobe.CalciferUtil;
import de.audiophobe.parser.ClassParser;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;

public class JavaClassParser
extends ClassParser {
    @Override
    public void parseClass(File classFile, CalciferProject calciferProject, Log log, ClassLoader classLoader) {
        try {
            log.info((CharSequence)("Parse Java " + classFile.getAbsolutePath()));
            List<String> lines = CalciferUtil.INSTANCE.readAllLines(classFile, log);
            String packageName = lines.stream().filter(x -> x.startsWith("package")).map(x -> x.replaceFirst("package +", "").replaceAll(" *;.*", "")).findFirst().get();
            String className = classFile.getName().replace(".java", "");
            String canonicalName = packageName + "." + className;
            log.info((CharSequence)("Parse package " + canonicalName));
            Class<?> clazz = classLoader.loadClass(canonicalName);
            log.info((CharSequence)"Class loaded");
            if (clazz.isEnum()) {
                log.info((CharSequence)"is Enum");
                ?[] enumC = clazz.getEnumConstants();
                StringBuilder allEnumHeader = new StringBuilder();
                StringBuilder allEnumRows = new StringBuilder();
                allEnumRows.append("== " + canonicalName + "\n");
                List<Field> relevantFields = Arrays.stream(clazz.getDeclaredFields()).filter(x -> !x.isSynthetic() && !x.isEnumConstant()).collect(Collectors.toList());
                relevantFields = relevantFields.stream().filter(x -> Modifier.isPrivate(x.getModifiers())).collect(Collectors.toList());
                relevantFields.forEach(x -> x.setAccessible(true));
                for (Field field : relevantFields) {
                    log.info((CharSequence)("Field " + field.getName() + " Mod " + field.getModifiers() + " " + Modifier.toString(field.getModifiers())));
                }
                List<String> fieldnames = relevantFields.stream().map(x -> x.getName()).collect(Collectors.toList());
                log.info((CharSequence)("Relevant fields: " + fieldnames.stream().collect(Collectors.joining(", "))));
                allEnumHeader.append("|===\n");
                allEnumHeader.append("|name");
                fieldnames.forEach(x -> allEnumHeader.append("|" + x));
                allEnumHeader.append("\n");
                allEnumRows.append(allEnumHeader.toString());
                if (enumC != null && enumC.length > 0) {
                    log.info((CharSequence)("Enum with " + enumC.length + " entries"));
                    for (Object o : enumC) {
                        log.info((CharSequence)("Enum Object " + o));
                        String singleEnumRow = "";
                        singleEnumRow = singleEnumRow + "|" + o.toString();
                        for (Field field : relevantFields) {
                            log.info((CharSequence)("Enum Field: " + field.getName() + ", Type: " + field.getGenericType()));
                            Object valO = field.get(o);
                            singleEnumRow = singleEnumRow + "|";
                            if (valO == null) continue;
                            singleEnumRow = singleEnumRow + valO.toString();
                        }
                        String canonicalFieldName = canonicalName + "." + o.toString();
                        String canonicalNoclassFieldName = className + "." + o.toString();
                        singleEnumRow = singleEnumRow + "\n";
                        allEnumRows.append(singleEnumRow + "\n");
                        singleEnumRow = allEnumHeader + singleEnumRow + "|===\n";
                        calciferProject.getField(canonicalFieldName).setContent(singleEnumRow.toString());
                        log.info((CharSequence)("Put in " + canonicalFieldName + " => " + singleEnumRow.toString()));
                        calciferProject.getField(canonicalNoclassFieldName).setContent(singleEnumRow.toString());
                        log.info((CharSequence)("Put in " + canonicalNoclassFieldName + " => " + singleEnumRow.toString()));
                    }
                }
                allEnumRows.append("|===\n");
                log.info((CharSequence)("Put in " + canonicalName + " => " + allEnumRows));
                calciferProject.getField(canonicalName).setContent(allEnumRows.toString());
                log.info((CharSequence)("Put in " + className + " => " + allEnumRows));
                calciferProject.getField(className).setContent(allEnumRows.toString());
            }
            if (!clazz.isEnum()) {
                log.info((CharSequence)"Class is no enum");
                for (Field field : clazz.getDeclaredFields()) {
                    String fieldname = field.getName();
                    log.info((CharSequence)("Found field " + fieldname));
                    String string = packageName + "." + className + "." + fieldname;
                    String canonicalFieldNameNoPac = className + "." + fieldname;
                    if (field.isSynthetic()) continue;
                    field.setAccessible(true);
                    log.info((CharSequence)("Field active: " + field.getName() + ", Type: " + field.getGenericType()));
                    try {
                        Object o = field.get(null);
                        if (o == null) continue;
                        if (o instanceof List) {
                            List oList = (List)o;
                            String oVal = "";
                            for (Object o2 : oList) {
                                oVal = oVal + ", " + o2.toString();
                            }
                            oVal = oVal.replaceFirst("..", "");
                            calciferProject.getField(fieldname).setContent(oVal);
                            calciferProject.getField(canonicalFieldNameNoPac).setContent(oVal);
                            calciferProject.getField(string).setContent(oVal);
                            log.info((CharSequence)("Field " + string + " => " + oVal));
                            continue;
                        }
                        String oVal = o.toString();
                        calciferProject.getField(fieldname).setContent(oVal);
                        calciferProject.getField(canonicalFieldNameNoPac).setContent(oVal);
                        calciferProject.getField(string).setContent(oVal);
                        log.info((CharSequence)("Field " + string + " => " + oVal));
                    }
                    catch (Exception e) {
                        log.info((CharSequence)("Ignore " + string + " for " + e.getMessage()));
                    }
                }
            }
        }
        catch (Throwable e) {
            log.error((CharSequence)("Ignored File " + classFile.getAbsolutePath() + " for " + e.getMessage()), e);
        }
    }
}

