/*
 * Decompiled with CFR 0.152.
 */
package de.audiophobe.parser;

import de.audiophobe.CalciferCodeLine;
import de.audiophobe.CalciferUtil;
import de.audiophobe.parser.SouceParser;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;

public class JavaSourceParser
extends SouceParser {
    public boolean extractJavadocStart(String s) {
        String regexp;
        Pattern p;
        Matcher m;
        return s != null && !s.isEmpty() && (m = (p = Pattern.compile(regexp = " */\\*\\*\\* *")).matcher(s)).matches();
    }

    public boolean extractJavadocEnde(String s) {
        String regexp;
        Pattern p;
        Matcher m;
        return s != null && !s.isEmpty() && (m = (p = Pattern.compile(regexp = " *\\*/ *")).matcher(s)).matches();
    }

    public String extractCalciferExp(String s) {
        String regexp;
        Pattern p;
        Matcher m;
        if (s != null && !s.isEmpty() && (m = (p = Pattern.compile(regexp = ".*///(.*)")).matcher(s)).matches()) {
            return m.group(1);
        }
        return null;
    }

    @Override
    public List<CalciferCodeLine> extractLines(File javaSource, Log log) {
        ArrayList<CalciferCodeLine> allCodeLines;
        block7: {
            allCodeLines = new ArrayList<CalciferCodeLine>();
            try {
                List<String> lines = CalciferUtil.INSTANCE.readAllLines(javaSource, log);
                ArrayList<String> allComments = new ArrayList<String>();
                if (lines.size() <= 0) break block7;
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    String rawLine = lines.get(i);
                    boolean javaDocStart = this.extractJavadocStart(line);
                    if (javaDocStart) {
                        line = lines.get(++i);
                        while (!this.extractJavadocEnde(line)) {
                            if (!line.matches(".*(@param|@return|@throws).*")) {
                                String lineWithSpace = line.replaceFirst(" *\\* ", "");
                                line = line.replaceFirst(" *\\* *", "");
                                allComments.add(line);
                                allCodeLines.add(new CalciferCodeLine(rawLine, line, lineWithSpace, i));
                            }
                            line = lines.get(++i);
                        }
                        continue;
                    }
                    String x = this.extractCalciferExp(line);
                    if (x != null) {
                        allComments.add(x);
                        allCodeLines.add(new CalciferCodeLine(rawLine, x, x, i));
                        continue;
                    }
                    allComments.add(null);
                    allCodeLines.add(new CalciferCodeLine(rawLine, null, null, i));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return allCodeLines;
    }
}

