/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import de.bild.codec.AbstractTypeCodec;
import de.bild.codec.MappedField;
import de.bild.codec.PojoContext;
import de.bild.codec.ReflectionCodec;
import de.bild.codec.TypeCodec;
import de.bild.codec.TypeCodecRegistry;
import de.bild.codec.annotations.Discriminator;
import de.bild.codec.annotations.DiscriminatorFallback;
import de.bild.codec.annotations.DiscriminatorKey;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolymorphicReflectionCodec<T>
implements TypeCodec<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolymorphicReflectionCodec.class);
    final Class<T> clazz;
    final Map<String, ReflectionCodec> discriminatorToCodec = new HashMap<String, ReflectionCodec>();
    final Map<Class<?>, ReflectionCodec<T>> classToCodec = new HashMap();
    final Map<Class<?>, String> mainDiscriminators = new HashMap();
    final Map<Class<?>, String> discriminatorKeys = new HashMap();
    final Set<String> allDiscriminatorKeys = new HashSet<String>();
    ReflectionCodec fallBackCodec;
    final boolean isCollectible;

    public PolymorphicReflectionCodec(Type type, Set<Type> validTypes, TypeCodecRegistry typeCodecRegistry, PojoContext pojoContext) {
        this.clazz = AbstractTypeCodec.extractClass(type);
        boolean isAnyCodecCollectible = false;
        for (Type type2 : validTypes) {
            Class clazz = AbstractTypeCodec.extractClass(type2);
            if (clazz.isInterface()) continue;
            String discriminatorKey = this.getDiscriminatorKeyForClass(clazz);
            boolean isFallBack = clazz.getDeclaredAnnotation(DiscriminatorFallback.class) != null;
            this.discriminatorKeys.putIfAbsent(clazz, discriminatorKey);
            this.allDiscriminatorKeys.add(discriminatorKey);
            ReflectionCodec codecFor = pojoContext.resolve(type2, typeCodecRegistry);
            if (isFallBack) {
                if (this.fallBackCodec != null) {
                    LOGGER.error("It is not allowed to declare more han one class within hierarchy as fallback. {} found already {}", clazz, (Object)codecFor.getEncoderClass());
                    throw new IllegalArgumentException("It is not allowed to declare more han one class within hierarchy as fallback." + clazz);
                }
                this.fallBackCodec = codecFor;
                LOGGER.debug("Found fallback discriminator at class {}", clazz);
            }
            isAnyCodecCollectible |= codecFor.isCollectible();
            this.classToCodec.put(clazz, codecFor);
            Discriminator discriminatorAnnotation = clazz.getDeclaredAnnotation(Discriminator.class);
            String mainDiscriminator = clazz.getSimpleName();
            ArrayList<String> allDiscriminators = new ArrayList<String>();
            if (discriminatorAnnotation != null) {
                if (discriminatorAnnotation.value() != null) {
                    mainDiscriminator = discriminatorAnnotation.value();
                }
                allDiscriminators.add(mainDiscriminator);
                for (String alias : discriminatorAnnotation.aliases()) {
                    allDiscriminators.add(alias);
                }
            } else {
                allDiscriminators.add(mainDiscriminator);
            }
            for (String discriminator : allDiscriminators) {
                ReflectionCodec registeredCodec = this.discriminatorToCodec.putIfAbsent(discriminator, codecFor);
                if (registeredCodec == null) continue;
                LOGGER.warn("Cannot register multiple classes ({}, {}) for the same discriminator {} ", new Object[]{clazz, registeredCodec.getEncoderClass(), discriminator});
                throw new IllegalArgumentException("Cannot register multiple classes (" + clazz + ", " + registeredCodec.getEncoderClass() + ") for the same discriminator " + discriminator);
            }
            this.mainDiscriminators.put(clazz, mainDiscriminator);
        }
        for (ReflectionCodec reflectionCodec : this.classToCodec.values()) {
            for (String allDiscriminatorKey : this.allDiscriminatorKeys) {
                MappedField mappedField = reflectionCodec.getMappedField(allDiscriminatorKey);
                if (mappedField == null) continue;
                LOGGER.error("A field {} within {} is named like one of the discriminator keys {}", new Object[]{mappedField.getMappedFieldName(), reflectionCodec.getEncoderClass(), this.allDiscriminatorKeys});
                throw new IllegalArgumentException("A field " + mappedField.getMappedFieldName() + " within " + reflectionCodec.getEncoderClass() + " is named like one of the discriminator keys " + this.allDiscriminatorKeys);
            }
        }
        this.isCollectible = isAnyCodecCollectible;
        LOGGER.debug("Type {} -> Found the following matching types {}", (Object)type, this.discriminatorToCodec);
    }

    private String getDiscriminatorKeyForClass(Class<?> clazz) {
        DiscriminatorKey discriminatorKey = clazz.getAnnotation(DiscriminatorKey.class);
        if (discriminatorKey != null && discriminatorKey.value() != null && discriminatorKey.value().length() > 0) {
            return discriminatorKey.value();
        }
        return "_t";
    }

    public T decode(BsonReader reader, DecoderContext decoderContext) {
        String discriminator = null;
        reader.mark();
        reader.readStartDocument();
        ReflectionCodec codec = null;
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = reader.readName();
            if (this.allDiscriminatorKeys.contains(fieldName)) {
                discriminator = reader.readString();
                codec = this.getCodecForDiscriminator(discriminator);
                if (codec == null) continue;
                String discriminatorKeyForClass = this.discriminatorKeys.get(codec.getEncoderClass());
                if (fieldName.equals(discriminatorKeyForClass)) break;
                discriminator = null;
                codec = null;
                LOGGER.warn("Confusing. Skipping discriminator {} encoded in discriminator key {} since the destination class is declaring a different discriminator key {}.", new Object[]{discriminator, fieldName, discriminatorKeyForClass});
                continue;
            }
            reader.skipValue();
        }
        reader.reset();
        if (codec == null) {
            LOGGER.debug("No discriminator found in db for entity. Trying fallback. Fallback is {}", (Object)this.fallBackCodec);
            codec = this.fallBackCodec;
        }
        if (codec == null) {
            LOGGER.warn("No matching codec found for discriminator {} within discriminatorToCodec {}", (Object)discriminator, this.discriminatorToCodec);
            reader.skipValue();
            return null;
        }
        return this.decodeWithType(reader, decoderContext, codec);
    }

    protected T decodeWithType(BsonReader reader, DecoderContext decoderContext, ReflectionCodec<T> typeCodec) {
        return (T)typeCodec.decode(reader, decoderContext);
    }

    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        ReflectionCodec<T> codecForValue = this.getCodecForClass(value.getClass());
        if (codecForValue != null) {
            writer.writeStartDocument();
            writer.writeName(this.discriminatorKeys.get(codecForValue.getEncoderClass()));
            writer.writeString(this.mainDiscriminators.get(codecForValue.getEncoderClass()));
            this.encodeType(writer, value, encoderContext, codecForValue);
            writer.writeEndDocument();
        } else {
            LOGGER.warn("The value to be encoded has the wrong type {}. This codec can only handle {}", value.getClass(), this.discriminatorToCodec);
        }
    }

    private ReflectionCodec getCodecForDiscriminator(String discriminator) {
        if (discriminator == null) {
            LOGGER.warn("Discriminator key cannot be null.");
            return null;
        }
        return this.discriminatorToCodec.get(discriminator);
    }

    private ReflectionCodec<T> getCodecForClass(Class<?> clazz) {
        if (Object.class.equals(clazz)) {
            return null;
        }
        ReflectionCodec<T> codec = this.classToCodec.get(clazz);
        if (codec != null) {
            return codec;
        }
        return this.getCodecForClass(clazz.getSuperclass());
    }

    private ReflectionCodec<T> getCodecForValue(T document) {
        return this.getCodecForClass(document.getClass());
    }

    protected void encodeType(BsonWriter writer, T value, EncoderContext encoderContext, ReflectionCodec<T> typeCodec) {
        typeCodec.encodeFields(writer, value, encoderContext);
    }

    public Class<T> getEncoderClass() {
        return this.clazz;
    }

    @Override
    public boolean isCollectible() {
        return this.isCollectible;
    }

    @Override
    public T generateIdIfAbsentFromDocument(T document) {
        ReflectionCodec<T> codecForValue = this.getCodecForValue(document);
        if (codecForValue != null) {
            codecForValue.generateIdIfAbsentFromDocument(document);
        }
        return document;
    }

    @Override
    public boolean documentHasId(T document) {
        ReflectionCodec<T> codecForValue = this.getCodecForValue(document);
        if (codecForValue != null) {
            return codecForValue.documentHasId(document);
        }
        return false;
    }

    @Override
    public BsonValue getDocumentId(T document) {
        ReflectionCodec<T> codecForValue = this.getCodecForValue(document);
        if (codecForValue != null) {
            return codecForValue.getDocumentId(document);
        }
        return null;
    }
}

