/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import de.bild.codec.ReflectionHelper;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ClassUtils;

public class TypesModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypesModel.class);
    protected final Set<Class<?>> allClasses = new HashSet();
    protected final Map<Class<?>, ClassHierarchyNode> classHierarchy;

    public TypesModel(Set<Class<?>> classes, Set<String> packages) {
        if (classes != null) {
            for (Class<?> aClass : classes) {
                this.indexClass(aClass);
            }
        }
        if (packages != null && !packages.isEmpty()) {
            Indexer indexer = this.getIndexer();
            for (String aPackage : packages) {
                for (Class<?> clazz : indexer.getClassesForPackage(aPackage)) {
                    this.indexClass(clazz);
                }
            }
        }
        this.classHierarchy = this.buildClassHierarchy(this.allClasses);
    }

    private Indexer getIndexer() {
        final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            classLoader.loadClass("org.springframework.core.io.Resource");
            return new Indexer(){

                @Override
                public List<Class<?>> getClassesForPackage(String packageName) {
                    ArrayList classes = new ArrayList();
                    try {
                        PathMatchingResourcePatternResolver scanner = new PathMatchingResourcePatternResolver();
                        String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)packageName) + "/**/*.class";
                        Resource[] resources = scanner.getResources(pattern);
                        Pattern classPattern = this.getPatternForPackage(packageName);
                        for (Resource resource : resources) {
                            Class<?> aClass = this.loadClass(classPattern, resource.toString(), classLoader);
                            if (aClass == null) continue;
                            classes.add(aClass);
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Could not load classes for package {}", (Object)packageName, (Object)e);
                    }
                    return classes;
                }
            };
        }
        catch (ClassNotFoundException e) {
            LOGGER.info("Could not find spring-core to use indexing packages, trying org.reflections.Reflections...");
            try {
                classLoader.loadClass("org.reflections.Reflections");
                return new Indexer(){

                    @Override
                    public List<Class<?>> getClassesForPackage(String packageName) {
                        ArrayList classes = new ArrayList();
                        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().addUrls(ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new ResourcesScanner()}));
                        Set resources = reflections.getResources(Pattern.compile(".*\\.class"));
                        Pattern classPattern = this.getPatternForPackage(packageName);
                        for (String resource : resources) {
                            Class<?> aClass = this.loadClass(classPattern, resource, classLoader);
                            if (aClass == null) continue;
                            classes.add(aClass);
                        }
                        return classes;
                    }
                };
            }
            catch (ClassNotFoundException e1) {
                LOGGER.error("Could not find org.reflections.reflections library in class path. Please provide either org.reflections.reflections or spring-core.");
                throw new IllegalStateException("Could not find org.reflections.reflections library in class path. Please provide either org.reflections.reflections or spring-core.");
            }
        }
    }

    private Map<Class<?>, ClassHierarchyNode> buildClassHierarchy(Set<Class<?>> allClasses) {
        HashMap clazzHierarchy = new HashMap();
        for (Class<?> aClass : allClasses) {
            this.addClassToHierarchy(aClass, clazzHierarchy);
        }
        return clazzHierarchy;
    }

    private ClassHierarchyNode addClassToHierarchy(Class<?> classToBeAdded, Map<Class<?>, ClassHierarchyNode> clazzHierarchy) {
        ClassHierarchyNode classHierarchyNode = clazzHierarchy.get(classToBeAdded);
        if (classHierarchyNode == null && this.allClasses.contains(classToBeAdded)) {
            classHierarchyNode = new ClassHierarchyNode(classToBeAdded);
            clazzHierarchy.put(classToBeAdded, classHierarchyNode);
            ClassHierarchyNode superNode = this.addClassToHierarchy(classToBeAdded.getSuperclass(), clazzHierarchy);
            if (superNode != null) {
                superNode.addChild(classHierarchyNode);
            }
            for (Class<?> anInterface : classToBeAdded.getInterfaces()) {
                ClassHierarchyNode interfaceNode = this.addClassToHierarchy(anInterface, clazzHierarchy);
                if (interfaceNode == null) continue;
                interfaceNode.addChild(classHierarchyNode);
            }
        }
        return classHierarchyNode;
    }

    private void indexClass(Class<?> clazz) {
        boolean added;
        if ((clazz.getEnclosingClass() == null || clazz.getEnclosingClass() != null && Modifier.isStatic(clazz.getModifiers())) && (added = this.allClasses.add(clazz))) {
            LOGGER.debug("Adding class to index: {}", clazz);
            for (Class<?> innerClass : clazz.getDeclaredClasses()) {
                this.indexClass(innerClass);
            }
        }
    }

    protected ClassHierarchyNode getClassHierarchyNodeForType(Type type) {
        ClassHierarchyNode classHierarchyNode = null;
        for (Class currentClass = ReflectionHelper.extractRawClass(type); classHierarchyNode == null && currentClass != null && !Object.class.equals((Object)currentClass); currentClass = currentClass.getSuperclass()) {
            classHierarchyNode = this.classHierarchy.get(currentClass);
        }
        return classHierarchyNode;
    }

    public Set<Type> getAssignableTypesWithinClassHierarchy(Type type) {
        HashSet<Type> validTypes = new HashSet<Type>();
        this.getAssignableTypesWithinClassHierarchy(type, validTypes);
        return validTypes;
    }

    private void getAssignableTypesWithinClassHierarchy(Type type, Set<Type> validTypes) {
        ClassHierarchyNode classHierarchyNodeForType = this.getClassHierarchyNodeForType(type);
        type = this.downGradeType(type, classHierarchyNodeForType);
        this.getAssignableTypesWithinClassHierarchy(type, classHierarchyNodeForType, validTypes);
    }

    private Type downGradeType(Type type, ClassHierarchyNode classHierarchyNodeForType) {
        if (classHierarchyNodeForType == null) {
            return type;
        }
        Class<?> clazz = classHierarchyNodeForType.getClazz();
        if (TypeUtils.isAssignable(clazz, (Type)type)) {
            return type;
        }
        if (clazz.getTypeParameters().length > 0) {
            return TypeUtils.parameterize(clazz, (Map)TypeUtils.getTypeArguments((Type)type, clazz));
        }
        return clazz;
    }

    private void getAssignableTypesWithinClassHierarchy(Type type, ClassHierarchyNode classHierarchyNode, Set<Type> validTypes) {
        if (classHierarchyNode != null) {
            Class<?> clazz = classHierarchyNode.getClazz();
            Type matchingType = null;
            if (TypeUtils.isAssignable(clazz, (Type)type)) {
                matchingType = type instanceof ParameterizedType ? this.getMatchingType((ParameterizedType)type, clazz) : clazz;
            }
            if (!clazz.isInterface() && matchingType != null) {
                validTypes.add(matchingType);
            }
            if (matchingType != null) {
                for (ClassHierarchyNode child : classHierarchyNode.getChildren()) {
                    this.getAssignableTypesWithinClassHierarchy(matchingType, child, validTypes);
                }
            }
        }
    }

    private Type getMatchingType(ParameterizedType parameterizedType, Class<?> clazz) {
        Type matchingType = null;
        if (parameterizedType.getRawType().equals(clazz)) {
            matchingType = parameterizedType;
        } else {
            Type genericSuperclass = null;
            if (ReflectionHelper.extractRawClass(parameterizedType).isInterface()) {
                for (Type genericInterface : clazz.getGenericInterfaces()) {
                    if (!TypeUtils.isAssignable((Type)genericInterface, (Type)parameterizedType)) continue;
                    genericSuperclass = genericInterface;
                    break;
                }
            } else {
                genericSuperclass = clazz.getGenericSuperclass();
            }
            if (genericSuperclass instanceof ParameterizedType) {
                ParameterizedType parameterizedSuperClassType = (ParameterizedType)genericSuperclass;
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                Type[] superClassTypeArguments = parameterizedSuperClassType.getActualTypeArguments();
                HashMap<String, Type> parameter = new HashMap<String, Type>();
                for (int i = 0; i < superClassTypeArguments.length; ++i) {
                    Type classTypeArgument = superClassTypeArguments[i];
                    if (!(classTypeArgument instanceof TypeVariable)) continue;
                    if (actualTypeArguments[i] instanceof WildcardType) {
                        WildcardType wildcardType = (WildcardType)actualTypeArguments[i];
                        parameter.put(((TypeVariable)classTypeArgument).getName(), wildcardType.getUpperBounds()[0]);
                        continue;
                    }
                    parameter.put(((TypeVariable)classTypeArgument).getName(), actualTypeArguments[i]);
                }
                TypeVariable<Class<?>>[] typeParameters = clazz.getTypeParameters();
                Type[] specifiedTypeArguments = new Type[typeParameters.length];
                for (int i = 0; i < typeParameters.length; ++i) {
                    Type inferredType = TypesModel.inferRealType(typeParameters[i], parameter);
                    if (!TypeUtils.isAssignable((Type)inferredType, (Type)typeParameters[i].getBounds()[0])) {
                        return null;
                    }
                    specifiedTypeArguments[i] = inferredType;
                }
                matchingType = specifiedTypeArguments.length > 0 ? TypeUtils.parameterize(clazz, (Type[])specifiedTypeArguments) : clazz;
            } else {
                LOGGER.debug("Type {} will be ignored as it has no generic superclass, but should have.", clazz);
            }
        }
        return matchingType;
    }

    private static Type inferRealType(Type clazzTypeParameter, Map<String, Type> superClassTypeMap) {
        if (clazzTypeParameter instanceof ParameterizedType) {
            ParameterizedType bound = (ParameterizedType)clazzTypeParameter;
            ArrayList<Type> typeList = new ArrayList<Type>();
            for (int i = 0; i < bound.getActualTypeArguments().length; ++i) {
                typeList.add(TypesModel.inferRealType(bound.getActualTypeArguments()[i], superClassTypeMap));
            }
            return TypeUtils.parameterizeWithOwner((Type)bound.getOwnerType(), (Class)((Class)bound.getRawType()), (Type[])typeList.toArray(new Type[0]));
        }
        if (clazzTypeParameter instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)clazzTypeParameter;
            Type newType = superClassTypeMap.get(typeVariable.getName());
            if (newType != null) {
                return newType;
            }
            return TypesModel.inferRealType(typeVariable.getBounds()[0], superClassTypeMap);
        }
        return clazzTypeParameter;
    }

    public static class ClassHierarchyNode {
        Class<?> clazz;
        Set<ClassHierarchyNode> children = new HashSet<ClassHierarchyNode>();

        public ClassHierarchyNode(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public Set<ClassHierarchyNode> getChildren() {
            return this.children;
        }

        public boolean isPolymorphic() {
            return this.getAllConcreteChildren().size() > 1;
        }

        public Set<Class<?>> getAllConcreteChildren() {
            return this.getAllChildrenRecursive(new HashSet());
        }

        private Set<Class<?>> getAllChildrenRecursive(Set<Class<?>> currentChildren) {
            if (!this.getClazz().isInterface()) {
                currentChildren.add(this.getClazz());
            }
            for (ClassHierarchyNode child : this.children) {
                child.getAllChildrenRecursive(currentChildren);
            }
            return currentChildren;
        }

        public boolean addChild(ClassHierarchyNode child) {
            return this.children.add(child);
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }
    }

    static interface Indexer {
        public List<Class<?>> getClassesForPackage(String var1);

        default public Class<?> loadClass(Pattern classPattern, String resourceName, ClassLoader classLoader) {
            try {
                String resourcePathWithDots = resourceName.replace('/', '.');
                Matcher matcher = classPattern.matcher(resourcePathWithDots);
                if (matcher.matches()) {
                    return classLoader.loadClass(matcher.group(1));
                }
            }
            catch (Exception e) {
                LOGGER.warn("Could not load class {}", (Object)resourceName, (Object)e);
            }
            return null;
        }

        default public Pattern getPatternForPackage(String packageName) {
            return Pattern.compile(".*?(" + packageName.replace(".", "\\.") + "\\..+)\\.class.*");
        }
    }
}

