/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import de.bild.codec.TypeCodec;
import de.bild.codec.TypeCodecRegistry;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayCodec
implements TypeCodec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrayCodec.class);
    final Codec arrayElementCodec;
    final boolean isPrimitive;
    final Class<?> arrayType;

    public ArrayCodec(Type type, TypeCodecRegistry typeCodecRegistry) {
        if (type instanceof Class) {
            Class<?> currentComponentType;
            this.arrayType = currentComponentType = (Class<?>)type;
            while (currentComponentType.isArray()) {
                currentComponentType = currentComponentType.getComponentType();
            }
            if (currentComponentType == Byte.TYPE) {
                this.isPrimitive = true;
                this.arrayElementCodec = typeCodecRegistry.getCodec((Type)((Object)byte[].class));
            } else if (currentComponentType.isPrimitive()) {
                this.isPrimitive = true;
                this.arrayElementCodec = PrimitiveType.get(currentComponentType);
            } else {
                this.isPrimitive = false;
                this.arrayElementCodec = typeCodecRegistry.getCodec(currentComponentType);
            }
        } else if (type instanceof GenericArrayType) {
            this.isPrimitive = false;
            Type currentLevelType = type;
            int level = 0;
            while (currentLevelType instanceof GenericArrayType) {
                currentLevelType = ((GenericArrayType)currentLevelType).getGenericComponentType();
                ++level;
            }
            Class<?> currentArrayClass = null;
            if (currentLevelType instanceof ParameterizedType) {
                currentArrayClass = (Class<?>)((ParameterizedType)currentLevelType).getRawType();
            }
            for (int i = 0; i < level; ++i) {
                currentArrayClass = Array.newInstance(currentArrayClass, 0).getClass();
            }
            this.arrayType = currentArrayClass;
            Type genericComponentType = currentLevelType;
            if (!(genericComponentType instanceof ParameterizedType)) {
                throw new IllegalArgumentException("Unable to determine array class! " + type);
            }
            this.arrayElementCodec = typeCodecRegistry.getCodec(genericComponentType);
        } else {
            throw new IllegalArgumentException("Unknown array type?!" + type);
        }
    }

    public void encode(BsonWriter writer, Object array, EncoderContext encoderContext) {
        this.encodeDimension(writer, array, encoderContext, this.arrayType);
    }

    private void encodeDimension(BsonWriter writer, Object array, EncoderContext encoderContext, Class<?> componentType) {
        boolean encodeLastDimension;
        Class<?> childComponentType = componentType.getComponentType();
        boolean bl = encodeLastDimension = !childComponentType.isArray();
        if (childComponentType == Byte.TYPE) {
            this.arrayElementCodec.encode(writer, array, encoderContext);
        } else {
            writer.writeStartArray();
            if (encodeLastDimension) {
                if (this.isPrimitive) {
                    this.arrayElementCodec.encode(writer, array, encoderContext);
                } else {
                    for (int i = 0; i < Array.getLength(array); ++i) {
                        this.arrayElementCodec.encode(writer, Array.get(array, i), encoderContext);
                    }
                }
            } else {
                for (int i = 0; i < Array.getLength(array); ++i) {
                    this.encodeDimension(writer, Array.get(array, i), encoderContext, childComponentType);
                }
            }
            writer.writeEndArray();
        }
    }

    public Object decode(BsonReader reader, DecoderContext decoderContext) {
        return this.decodeDimension(reader, decoderContext, this.arrayType);
    }

    private Object decodeDimension(BsonReader reader, DecoderContext decoderContext, Class<?> componentType) {
        boolean decodeLastDimension;
        Object array = null;
        Class<?> childComponentType = componentType.getComponentType();
        boolean bl = decodeLastDimension = !childComponentType.isArray();
        if (childComponentType == Byte.TYPE) {
            array = this.arrayElementCodec.decode(reader, decoderContext);
        } else if (BsonType.ARRAY.equals((Object)reader.getCurrentBsonType())) {
            reader.readStartArray();
            if (decodeLastDimension) {
                if (this.isPrimitive) {
                    array = this.arrayElementCodec.decode(reader, decoderContext);
                } else {
                    ArrayList<Object> list = new ArrayList<Object>();
                    while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                        list.add(this.arrayElementCodec.decode(reader, decoderContext));
                    }
                    array = Array.newInstance(childComponentType, list.size());
                    for (int i = 0; i < list.size(); ++i) {
                        Array.set(array, i, list.get(i));
                    }
                }
            } else {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    Object decoded = this.decodeDimension(reader, decoderContext, childComponentType);
                    arrayList.add(decoded);
                }
                array = Array.newInstance(childComponentType, arrayList.size());
                for (int i = 0; i < arrayList.size(); ++i) {
                    Array.set(array, i, arrayList.get(i));
                }
            }
            reader.readEndArray();
        } else {
            LOGGER.warn("Expected {} from reader but got {}. Skipping value.", (Object)BsonType.ARRAY, (Object)reader.getCurrentBsonType());
            reader.skipValue();
        }
        return array;
    }

    public Class getEncoderClass() {
        return this.arrayType;
    }

    private static enum PrimitiveType implements TypeCodec
    {
        BOOLEAN((Class)Boolean.TYPE){

            public void encode(BsonWriter writer, Object value, EncoderContext encoderContext) {
                for (boolean i : (boolean[])value) {
                    writer.writeBoolean(i);
                }
            }

            public Object decode(BsonReader reader, DecoderContext decoderContext) {
                ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
                while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    arrayList.add(reader.readBoolean());
                }
                boolean[] booleans = new boolean[arrayList.size()];
                int i = 0;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    boolean aPrimitiveBoolean = (Boolean)iterator.next();
                    booleans[i++] = aPrimitiveBoolean;
                }
                return booleans;
            }
        }
        ,
        CHARACTER((Class)Character.TYPE){

            public void encode(BsonWriter writer, Object value, EncoderContext encoderContext) {
                for (char i : (char[])value) {
                    writer.writeInt32((int)i);
                }
            }

            public Object decode(BsonReader reader, DecoderContext decoderContext) {
                ArrayList<Character> arrayList = new ArrayList<Character>();
                while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    arrayList.add(Character.valueOf((char)reader.readInt32()));
                }
                char[] chars = new char[arrayList.size()];
                int i = 0;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    char aPrimitive = ((Character)iterator.next()).charValue();
                    chars[i++] = aPrimitive;
                }
                return chars;
            }
        }
        ,
        FLOAT((Class)Float.TYPE){

            public void encode(BsonWriter writer, Object value, EncoderContext encoderContext) {
                for (float i : (float[])value) {
                    writer.writeDouble((double)i);
                }
            }

            public Object decode(BsonReader reader, DecoderContext decoderContext) {
                ArrayList<Float> arrayList = new ArrayList<Float>();
                while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    arrayList.add(Float.valueOf((float)reader.readDouble()));
                }
                float[] floats = new float[arrayList.size()];
                int i = 0;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    float aPrimitive = ((Float)iterator.next()).floatValue();
                    floats[i++] = aPrimitive;
                }
                return floats;
            }
        }
        ,
        INTEGER((Class)Integer.TYPE){

            public void encode(BsonWriter writer, Object value, EncoderContext encoderContext) {
                for (int i : (int[])value) {
                    writer.writeInt32(i);
                }
            }

            public Object decode(BsonReader reader, DecoderContext decoderContext) {
                IntStream.Builder builder = IntStream.builder();
                while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    builder.add(reader.readInt32());
                }
                return builder.build().toArray();
            }
        }
        ,
        LONG((Class)Long.TYPE){

            public void encode(BsonWriter writer, Object value, EncoderContext encoderContext) {
                for (long i : (long[])value) {
                    writer.writeInt64(i);
                }
            }

            public Object decode(BsonReader reader, DecoderContext decoderContext) {
                LongStream.Builder builder = LongStream.builder();
                while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    builder.add(reader.readInt64());
                }
                return builder.build().toArray();
            }
        }
        ,
        SHORT((Class)Short.TYPE){

            public void encode(BsonWriter writer, Object value, EncoderContext encoderContext) {
                for (short i : (short[])value) {
                    writer.writeInt32((int)i);
                }
            }

            public Object decode(BsonReader reader, DecoderContext decoderContext) {
                ArrayList<Short> arrayList = new ArrayList<Short>();
                while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    arrayList.add((short)reader.readInt32());
                }
                short[] shorts = new short[arrayList.size()];
                int i = 0;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    short aPrimitive = (Short)iterator.next();
                    shorts[i++] = aPrimitive;
                }
                return shorts;
            }
        }
        ,
        DOUBLE((Class)Double.TYPE){

            public void encode(BsonWriter writer, Object value, EncoderContext encoderContext) {
                for (double i : (double[])value) {
                    writer.writeDouble(i);
                }
            }

            public Object decode(BsonReader reader, DecoderContext decoderContext) {
                ArrayList<Double> arrayList = new ArrayList<Double>();
                while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                    arrayList.add(reader.readDouble());
                }
                double[] doubles = new double[arrayList.size()];
                int i = 0;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    double aPrimitive = (Double)iterator.next();
                    doubles[i++] = aPrimitive;
                }
                return doubles;
            }
        };

        final Class<?> primitiveClass;
        static final Map<Class<?>, PrimitiveType> PRIMITIVE_CLASS_TO_TYPE;

        private PrimitiveType(Class<?> primitiveClass) {
            this.primitiveClass = primitiveClass;
        }

        public Class getEncoderClass() {
            return this.primitiveClass;
        }

        public static PrimitiveType get(Class type) {
            return PRIMITIVE_CLASS_TO_TYPE.get(type);
        }

        static {
            PRIMITIVE_CLASS_TO_TYPE = new HashMap();
            for (PrimitiveType primitiveType : PrimitiveType.values()) {
                PRIMITIVE_CLASS_TO_TYPE.put(primitiveType.primitiveClass, primitiveType);
            }
        }
    }
}

