/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import de.bild.codec.AbstractTypeCodec;
import de.bild.codec.FieldTypePair;
import de.bild.codec.IdGenerator;
import de.bild.codec.MappedField;
import de.bild.codec.MethodTypePair;
import de.bild.codec.ReflectionCodec;
import de.bild.codec.ReflectionHelper;
import de.bild.codec.TypeCodecRegistry;
import de.bild.codec.annotations.Id;
import de.bild.codec.annotations.PostLoad;
import de.bild.codec.annotations.PreSave;
import de.bild.codec.annotations.Transient;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicReflectionCodec<T>
extends AbstractTypeCodec<T>
implements ReflectionCodec<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicReflectionCodec.class);
    MappedField idField;
    final Map<String, MappedField> persistenceFields = new LinkedHashMap<String, MappedField>();
    final List<Method> postLoadMethods = new ArrayList<Method>();
    final List<Method> preSaveMethods = new ArrayList<Method>();
    IdGenerator idGenerator;
    boolean isCollectible;

    public BasicReflectionCodec(Type type, TypeCodecRegistry typeCodecRegistry) {
        super(type, typeCodecRegistry);
        for (FieldTypePair fieldTypePair : ReflectionHelper.getDeclaredAndInheritedFieldTypePairs(type, true)) {
            Field field = fieldTypePair.getField();
            if (this.isIgnorable(field)) continue;
            MappedField mappedField = new MappedField(fieldTypePair, this.encoderClass, typeCodecRegistry);
            this.persistenceFields.put(mappedField.getMappedFieldName(), mappedField);
            if (!mappedField.isIdField()) continue;
            if (this.idField == null) {
                this.idField = mappedField;
                Id idAnnotation = this.idField.getAnnotation(Id.class);
                Class<? extends IdGenerator> idGeneratorClass = idAnnotation.value();
                this.isCollectible = idAnnotation.collectible();
                try {
                    Constructor<? extends IdGenerator> idGeneratorConstructor = idGeneratorClass.getDeclaredConstructor(new Class[0]);
                    idGeneratorConstructor.setAccessible(true);
                    this.idGenerator = idGeneratorConstructor.newInstance(new Object[0]);
                    continue;
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalArgumentException("Could not create instance of IdGenerator for class " + type + " Generator class: " + idGeneratorClass, e);
                }
            }
            throw new IllegalArgumentException("Id field is used again in class hierarchy! Class " + this.encoderClass);
        }
        for (MethodTypePair methodTypePair : ReflectionHelper.getDeclaredAndInheritedMethods(this.encoderClass)) {
            Method method = methodTypePair.getMethod();
            if (method.isAnnotationPresent(PostLoad.class)) {
                this.postLoadMethods.add(method);
                continue;
            }
            if (!method.isAnnotationPresent(PreSave.class)) continue;
            this.preSaveMethods.add(method);
        }
    }

    @Override
    public Map<String, MappedField> getPersistenceFields() {
        return this.persistenceFields;
    }

    protected boolean isIgnorable(Field field) {
        return field.isAnnotationPresent(Transient.class) || Modifier.isTransient(field.getModifiers());
    }

    public T decode(BsonReader reader, DecoderContext decoderContext) {
        if (reader.getCurrentBsonType() == null || reader.getCurrentBsonType() == BsonType.DOCUMENT) {
            reader.readStartDocument();
            Object newInstance = this.decodeFields(reader, decoderContext, this.newInstance());
            reader.readEndDocument();
            return newInstance;
        }
        LOGGER.error("Expected to read document but reader is in state {}. Skipping value!", (Object)reader.getCurrentBsonType());
        reader.skipValue();
        return null;
    }

    @Override
    public T decodeFields(BsonReader reader, DecoderContext decoderContext, T instance) {
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = reader.readName();
            MappedField mappedField = this.persistenceFields.get(fieldName);
            if (mappedField != null) {
                mappedField.decode(reader, instance, decoderContext);
                continue;
            }
            reader.skipValue();
        }
        this.postDecode(instance);
        return instance;
    }

    @Override
    public void postDecode(T instance) {
        this.initializeDefaults(instance);
        for (Method postLoadMethod : this.postLoadMethods) {
            try {
                postLoadMethod.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.warn("@PostLoad method {} could not be called.", (Object)postLoadMethod, (Object)e);
            }
        }
    }

    @Override
    public void initializeDefaults(T instance) {
        for (MappedField persistenceField : this.persistenceFields.values()) {
            persistenceField.initializeDefault(instance);
        }
    }

    public void encode(BsonWriter writer, T instance, EncoderContext encoderContext) {
        writer.writeStartDocument();
        this.encodeFields(writer, instance, encoderContext);
        writer.writeEndDocument();
    }

    @Override
    public void encodeFields(BsonWriter writer, T instance, EncoderContext encoderContext) {
        this.preEncode(instance);
        for (MappedField persistenceField : this.persistenceFields.values()) {
            persistenceField.encode(writer, instance, encoderContext);
        }
    }

    @Override
    public void preEncode(T instance) {
        for (Method preSaveMethod : this.preSaveMethods) {
            try {
                preSaveMethod.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.warn("@PreSave method {} could not be called.", (Object)preSaveMethod, (Object)e);
            }
        }
    }

    @Override
    public MappedField getMappedField(String mappedFieldName) {
        return this.persistenceFields.get(mappedFieldName);
    }

    @Override
    public MappedField getIdField() {
        return this.idField;
    }

    @Override
    public boolean isCollectible() {
        return this.isCollectible;
    }

    @Override
    public T generateIdIfAbsentFromDocument(T document) {
        boolean couldGenerate;
        if (this.idGenerator != null && !this.documentHasId(document) && !(couldGenerate = this.idField.setFieldValue(document, this.idGenerator.generate()))) {
            LOGGER.error("Could not set id!");
        }
        return document;
    }

    @Override
    public boolean documentHasId(T document) {
        return this.getPlainId(document) != null;
    }

    private Object getPlainId(T document) {
        return this.idField != null ? this.idField.getFieldValue(document) : null;
    }

    @Override
    public BsonValue getDocumentId(T document) {
        return this.idGenerator.asBsonValue(this.getPlainId(document), this.typeCodecRegistry);
    }
}

