/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import de.bild.codec.ArrayCodec;
import de.bild.codec.BasicReflectionCodec;
import de.bild.codec.CodecResolver;
import de.bild.codec.ListTypeCodec;
import de.bild.codec.MapTypeCodec;
import de.bild.codec.PolymorphicReflectionCodec;
import de.bild.codec.ReflectionCodec;
import de.bild.codec.ReflectionHelper;
import de.bild.codec.SetTypeCodec;
import de.bild.codec.SpecialFieldsMap;
import de.bild.codec.SpecialFieldsMapCodec;
import de.bild.codec.TypeCodec;
import de.bild.codec.TypeCodecRegistry;
import de.bild.codec.TypesModel;
import de.bild.codec.annotations.Discriminator;
import de.bild.codec.annotations.Polymorphic;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(PojoContext.class);
    private static final FloatCodec FLOAT_CODEC = new FloatCodec();
    private static final ByteCodec BYTE_CODEC = new ByteCodec();
    private static final ShortCodec SHORT_CODEC = new ShortCodec();
    private final Map<Type, Codec<?>> codecMap = new ConcurrentHashMap();
    private final TypesModel typesModel;
    private final List<CodecResolver> codecResolvers;

    public PojoContext(TypesModel typesModel, List<CodecResolver> codecResolvers) {
        this.typesModel = typesModel;
        this.codecResolvers = codecResolvers;
    }

    public synchronized <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        return this.getCodec(clazz, new AnyTypeCodecRegistry(registry, this));
    }

    public synchronized <T> Codec<T> getCodec(Type type, TypeCodecRegistry typeCodecRegistry) {
        Object codec = this.codecMap.get(type);
        if (codec != null) {
            return codec;
        }
        LazyCodec lazyCodec = new LazyCodec(type, typeCodecRegistry);
        this.codecMap.put(type, lazyCodec);
        codec = this.calculateCodec(type, typeCodecRegistry);
        if (codec == null) {
            this.codecMap.remove(type);
        } else {
            this.codecMap.put(type, (Codec<?>)codec);
        }
        return codec;
    }

    public synchronized ReflectionCodec resolve(Type type, TypeCodecRegistry typeCodecRegistry) {
        for (CodecResolver codecResolver : this.codecResolvers) {
            ReflectionCodec codec = codecResolver.getCodec(type, typeCodecRegistry);
            if (codec == null) continue;
            return codec;
        }
        return new BasicReflectionCodec(type, typeCodecRegistry);
    }

    private <T> Codec<T> calculateCodec(Type type, TypeCodecRegistry typeCodecRegistry) {
        if (type.equals(byte[].class)) {
            return null;
        }
        if (TypeUtils.isArrayType((Type)type)) {
            return new ArrayCodec(type, typeCodecRegistry);
        }
        if (type instanceof TypeVariable) {
            throw new IllegalArgumentException("This registry (and probably no other one as well) can not handle generic type variables.");
        }
        if (type instanceof WildcardType) {
            LOGGER.error("WildcardTypes are not yet supported. {}", (Object)type);
            throw new NotImplementedException("WildcardTypes are not yet supported. " + type);
        }
        if (Float.class.equals((Object)type)) {
            return FLOAT_CODEC;
        }
        if (Short.class.equals((Object)type)) {
            return SHORT_CODEC;
        }
        if (Byte.class.equals((Object)type)) {
            return BYTE_CODEC;
        }
        if (TypeUtils.isAssignable((Type)type, Enum.class)) {
            return null;
        }
        if (TypeUtils.isAssignable((Type)type, SpecialFieldsMap.class)) {
            return new SpecialFieldsMapCodec(type, typeCodecRegistry);
        }
        TypeCodec codec = ListTypeCodec.getCodecIfApplicable(type, typeCodecRegistry);
        if (codec != null) {
            return codec;
        }
        codec = SetTypeCodec.getCodecIfApplicable(type, typeCodecRegistry);
        if (codec != null) {
            return codec;
        }
        codec = MapTypeCodec.getCodecIfApplicable(type, typeCodecRegistry);
        if (codec != null) {
            return codec;
        }
        Set<Type> validTypesForType = this.typesModel.getAssignableTypesWithinClassHierarchy(type);
        if (validTypesForType == null || validTypesForType.isEmpty()) {
            LOGGER.debug("Could not find concrete implementation for type {}. Maybe another codec is able to handle te class?!", (Object)type);
            return null;
        }
        if (validTypesForType.size() > 1 || this.isPolymorphic(type)) {
            LOGGER.debug("Creating polymorphic codec for type {} with valid types {}", (Object)type, validTypesForType);
            return new PolymorphicReflectionCodec(type, validTypesForType, typeCodecRegistry, this);
        }
        LOGGER.debug("Creating simple reflection based codec for type {} (generic type {}) as only one concrete implementation known.", (Object)type, validTypesForType);
        Type singleType = validTypesForType.iterator().next();
        codec = this.resolve(singleType, typeCodecRegistry);
        if (codec != null) {
            return codec;
        }
        return new BasicReflectionCodec(singleType, typeCodecRegistry);
    }

    private boolean isPolymorphic(Type type) {
        Class clazz = ReflectionHelper.extractRawClass(type);
        return clazz.getAnnotation(Polymorphic.class) != null || clazz.getDeclaredAnnotation(Discriminator.class) != null || this.isClassPartOfPolymorphicStructureWithinTypesModel(clazz);
    }

    private boolean isClassPartOfPolymorphicStructureWithinTypesModel(Class clazz) {
        Class superclass = clazz.getSuperclass();
        if (this.typesModel.getClassHierarchyNodeForType(superclass) != null) {
            return true;
        }
        for (Class<?> anInterface : clazz.getInterfaces()) {
            if (this.typesModel.getClassHierarchyNodeForType(anInterface) == null) continue;
            return true;
        }
        return false;
    }

    private static class ShortCodec
    extends org.bson.codecs.ShortCodec {
        private ShortCodec() {
        }

        public Short decode(BsonReader reader, DecoderContext decoderContext) {
            return (short)reader.readInt32();
        }
    }

    private static class ByteCodec
    extends org.bson.codecs.ByteCodec {
        private ByteCodec() {
        }

        public Byte decode(BsonReader reader, DecoderContext decoderContext) {
            return (byte)reader.readInt32();
        }
    }

    private static class FloatCodec
    extends org.bson.codecs.FloatCodec {
        private FloatCodec() {
        }

        public Float decode(BsonReader reader, DecoderContext decoderContext) {
            return Float.valueOf((float)reader.readDouble());
        }
    }

    private static class LazyCodec<T>
    implements TypeCodec<T> {
        private final Type type;
        private volatile Codec<T> wrapped;
        private final TypeCodecRegistry typeCodecRegistry;

        public LazyCodec(Type type, TypeCodecRegistry typeCodecRegistry) {
            this.type = type;
            this.typeCodecRegistry = typeCodecRegistry;
        }

        public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
            this.getWrapped().encode(writer, value, encoderContext);
        }

        public Class<T> getEncoderClass() {
            return this.getWrapped().getEncoderClass();
        }

        public T decode(BsonReader reader, DecoderContext decoderContext) {
            return (T)this.getWrapped().decode(reader, decoderContext);
        }

        private Codec<T> getWrapped() {
            if (this.wrapped == null) {
                this.wrapped = this.typeCodecRegistry.getCodec(this.type);
            }
            return this.wrapped;
        }
    }

    private static class AnyTypeCodecRegistry
    implements TypeCodecRegistry {
        final CodecRegistry codecRegistry;
        final PojoContext pojoContext;

        public AnyTypeCodecRegistry(CodecRegistry codecRegistry, PojoContext pojoContext) {
            this.codecRegistry = codecRegistry;
            this.pojoContext = pojoContext;
        }

        @Override
        public <T> Codec<T> getCodec(Type type) {
            Codec codec = this.pojoContext.getCodec(type, this);
            if (codec == null) {
                codec = this.codecRegistry.get(ReflectionHelper.extractRawClass(type));
            }
            return codec;
        }

        @Override
        public CodecRegistry getRegistry() {
            return this.codecRegistry;
        }
    }
}

