/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import de.bild.codec.CollectionTypeCodec;
import de.bild.codec.ReflectionHelper;
import de.bild.codec.TypeCodecRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;

public class SetTypeCodec<C extends Set<V>, V>
extends CollectionTypeCodec<C, V> {
    public SetTypeCodec(Class<C> collectionClass, Type valueType, TypeCodecRegistry typeCodecRegistry) {
        super(collectionClass, valueType, typeCodecRegistry);
    }

    @Override
    protected Constructor<C> getDefaultConstructor(Class<C> clazz) {
        if (clazz.isInterface()) {
            return super.getDefaultConstructor(LinkedHashSet.class);
        }
        return super.getDefaultConstructor(clazz);
    }

    public static SetTypeCodec getCodecIfApplicable(Type type, TypeCodecRegistry typeCodecRegistry) {
        Type setInterface;
        Class rawClass = ReflectionHelper.extractRawClass(type);
        if (rawClass != null && Set.class.isAssignableFrom(rawClass) && (setInterface = ReflectionHelper.findInterface(type, Set.class)) instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)setInterface;
            return new SetTypeCodec(rawClass, parameterizedType.getActualTypeArguments()[0], typeCodecRegistry);
        }
        return null;
    }
}

