/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import de.bild.codec.InstanceCreationException;
import de.bild.codec.TypeCodec;
import de.bild.codec.TypeCodecRegistry;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTypeCodec<T>
implements TypeCodec<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    final TypeCodecRegistry typeCodecRegistry;
    final Class<T> encoderClass;
    final Constructor<T> defaultConstructor;
    final Type type;

    public AbstractTypeCodec(Type type, TypeCodecRegistry typeCodecRegistry) {
        this.typeCodecRegistry = typeCodecRegistry;
        this.type = type;
        this.encoderClass = AbstractTypeCodec.extractClass(type);
        this.defaultConstructor = this.getDefaultConstructor(this.encoderClass);
    }

    static <T> Class<T> extractClass(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return AbstractTypeCodec.extractClass(wildcardType.getUpperBounds()[0]);
        }
        throw new IllegalArgumentException("Type is not supported." + type);
    }

    protected Constructor<T> getDefaultConstructor(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException | SecurityException e) {
            if (!Modifier.isStatic(clazz.getModifiers()) && clazz.getEnclosingClass() != null) {
                throw new IllegalArgumentException("Currently only static inner classes are supported! Consider using a static inner class instead for " + clazz);
            }
            throw new IllegalArgumentException("Please provide a default constructor for " + clazz + "!", e);
        }
    }

    @Override
    public T newInstance() {
        try {
            return this.defaultConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            this.logger.warn("Could not instantiate new instance" + this.defaultConstructor.getName());
            throw new InstanceCreationException("Could not instantiate new instance for constructor: " + this.defaultConstructor.getName() + " Please provide default constructor.", e);
        }
    }

    public Class<T> getEncoderClass() {
        return this.encoderClass;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + "{");
        sb.append("typeCodecRegistry=").append(this.typeCodecRegistry);
        sb.append(", encoderClass=").append(this.encoderClass);
        sb.append(", defaultConstructor=").append(this.defaultConstructor);
        sb.append(", type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }
}

